/*
Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
*/
#ifndef _SQBATCHDATASET_H_
#define _SQBATCHDATASET_H_

#include "SQDef.h"

/** @file SQBatchDataset.h

   This file list the dataset functionality for a batch dataset used in Umetrics SIMCA-Q products.
*/
#ifdef __cplusplus
extern "C" {
#endif 

#ifdef _WIN32
#pragma pack(push, 8)
#endif

#include "SQErrorCodes.h"
#include "SQDataset.h"

  /** @cond SQPPlus */
   
   /*******************************************************************************************
   *
   *                       Functions for a observation level datasets
   *
   *  All these functions are only valid if the dataset type is SQ_D_ObservationLevel
   *
   ********************************************************************************************/

   /**
   *  Retrieves the index of the batch ID column.
   *
   *  @param[in]   pDataset         The dataset to use
   *  @param[out]  piBatchID        The Batch ID column.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetBatchID(SQ_Dataset pDataset, int *piBatchID);
   /**
   *  Retrieves the index of the phase ID column.
   *
   *  @param[in]   pDataset         The dataset to use
   *  @param[out]  piPhaseID        The Phase ID column.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetPhaseID(SQ_Dataset pDataset, int *piPhaseID);


  /** @endcond // end of SQPPlus */

#ifdef _WIN32
#pragma pack(pop)
#endif

#ifdef __cplusplus
}
#endif /*__cplusplus*/


#endif /* _SQDATASET_H_ */
