/*
Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
*/
#ifndef _SQBATCHMODEL_H_
#define _SQBATCHMODEL_H_

#include "SQDef.h"

/** @file SQBatchModel.h

*/
#ifdef __cplusplus
extern "C" {
#endif 

  /** @cond SQPPlus */
   
#ifdef _WIN32
#pragma pack(push, 8)
#endif

   /** 
   The object used to identify a Batch model (BM).
   IMPORTANT: Always initialize it to NULL!
   */
   typedef struct tagSQ_BatchModel
   {
      /** Reserved, only used internally. */
      void* reserved;
   } *SQ_BatchModel;

#include "SQErrorCodes.h"
#include "SQModel.h"

   /**
   *  Get the number of Batch Level Models connected to this BM.
   *
   *  @param[in]  pBatchModel       The batch model to use
   *  @param[out] piNumBLM          Number of Batch Level Models in this BM.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetNumberOfBLM(SQ_BatchModel pBatchModel, int* piNumBLM);

   /**
   *  Get the model number of a Batch Level Model in this BM.
   *
   *  @param[in]  pBatchModel       The batch model to use
   *  @param[in]  iBLMIndex         The index of the BLM in this BM.
   *  @param[out] piBLModelNumber   The BL Model number.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetBatchLevelModelNumber(SQ_BatchModel pBatchModel, int iBLMIndex, int* piBLModelNumber);

   /**
   *  Get a Batch Level Model in this BM.
   *
   *  @param[in]  pBatchModel       The batch model to use
   *  @param[in]  iBLModelNumber    The Batch Level Model number.
   *  @param[out] pBatchLevelModel  The Batch Level Model.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetBatchLevelModel(SQ_BatchModel pBatchModel, int iBLModelNumber, SQ_Model* pBatchLevelModel);

   /**
   *  Get the number of Batch Evolution Models connected to this BM.
   *
   *  @param[in]  pBatchModel       The batch model to use
   *  @param[out] piNumBEM          Number of Batch Evolution Models in this BM.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetNumberOfBEM(SQ_BatchModel pBatchModel, int* piNumBEM);

   /**
   *  Get the model number of a Batch Evolution Model in this BM.
   *
   *  @param[in]  pBatchModel       The batch model to use
   *  @param[in]  iBEMIndex         The index of the BEM in this BM.
   *  @param[out] piBEModelNumber   The BE Model number.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetBatchEvolutionModelNumber(SQ_BatchModel pBatchModel, int iBEMIndex, int* piBEModelNumber);

   /**
   *  Get a Batch Evolution Model in this BM.
   *
   *  @param[in]  pBatchModel          The batch model to use
   *  @param[in]  iBEModelNumber       The Batch Evolution Model number.
   *  @param[out] pBatchEvolutionModel The Batch Evolution Model.
   *  @return                          Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetBatchEvolutionModel(SQ_BatchModel pBatchModel, int iBEModelNumber, SQ_Model* pBatchEvolutionModel);

  /** @endcond // end of SQPPlus */

#ifdef _WIN32
#pragma pack(pop)
#endif

#ifdef __cplusplus
}
#endif /*__cplusplus*/


#endif /* _SQBATCHMODEL_H_ */
