/*
Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
*/
#ifndef _SQBATCHPREDICTION_H_
#define _SQBATCHPREDICTION_H_

#include "SQDef.h"

/** @file SQBatchPrediction.h

   This file list the SQ_BatchPrediction object used to get data from a batch prediction.
*/
#ifdef __cplusplus
extern "C" {
#endif 

#ifdef _WIN32
#pragma pack(push, 8)
#endif

#include "SQErrorCodes.h"
#include "SQPrediction.h"

  /** @cond SQPPlus */
   
   /**
   The handle used to identify a prediction object.
   IMPORTANT: Always initialize it to NULL!
   */
   typedef struct tagSQ_BatchPrediction 
   {
      /** Reserved, only used internally. */
      void* reserved;
   } *SQ_BatchPrediction;

   /**
   *  Removes the allocated memory for the BatchPrediction object.
   *  This function must be called for every BatchPrediction object that is created,
   *  if not a memory leak will occur.
   *
   *  @param[in]   pPrediction   The Batch Prediction object to remove.
   *
   *  @return                    Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_ClearBatchPrediction(SQ_BatchPrediction* pPrediction);

   /** 
   *  Get the prediction handle for the batch level model that the prediction was performed on.
   *
   *  @param[in]  pBatchPrediction  The batch prediction object to use.  
   *  @param[out] pBLPrediction     The batch level prediction object that should be used to retrieve the prediction results.   
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetBatchLevelPrediction(SQ_BatchPrediction pBatchPrediction, SQ_Prediction* pBLPrediction);

   /** 
   *  Get the prediction handle for a batch evolution model that the prediction was performed on.
   *
   *  @param[in]  pBatchPrediction  The batch prediction object to use.  
   *  @param[in]  iModelNumber      The batch evolution model number to get the prediction for.  
   *  @param[out] pBEMPrediction    The batch evolution prediction object that should be used to retrieve the prediction results.   
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetBatchEvolutionPrediction(SQ_BatchPrediction pBatchPrediction, int iModelNumber, SQ_Prediction* pBEMPrediction);

  /** @endcond // end of SQPPlus */

#ifdef _WIN32
#pragma pack(pop)
#endif

#ifdef __cplusplus
}
#endif /*__cplusplus*/

#endif /* _SQBATCHPREDICTION_H_ */
