/*
Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
*/
#ifndef _SQBATCHPROJECT_H_
#define _SQBATCHPROJECT_H_

#include "SQDef.h"

/** @file SQBatchProject.h

*/
#ifdef __cplusplus
extern "C" {
#endif 

#ifdef _WIN32
#pragma pack(push, 8)
#endif

#include "SQErrorCodes.h"
#include "SQProject.h"
#include "SQBatchModel.h"

  /** @cond SQPPlus */
   
   /**
   *  An inquiry whether the project is a batch project.
   *
   *  @param[in]  pProject          The project to use
   *  @param[out] bIsBatchProject   Is set to SQ_True if the project is a batch project.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetIsBatchProject(SQ_Project pProject, SQ_Bool* bIsBatchProject);

   /**
   *  Retrieves the number of BM/BEM Models in the batch project.
   *  A BM, sequentially numbered, holds the BEM and the BLM-models built on datasets created from that BEM.
   *
   *  @param[in]  pProject          The project to use
   *  @param[out] piSizeBM         The number of BMs in the project.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetNumberOfBatchModels(SQ_Project pProject, int *piSizeBM);

   /**
   *  Retrieves the BM object in the model. 
   *  From the BatchModel object the Batch Evolution Models and Batch Level Models can be retrieved.
   *  A BM, sequentially numbered, holds the BEM and the BLM-models built on datasets created from that BEM.
   *
   *  @param[in]  pProject          The project to use
   *  @param[in]  iBMIndex          The index of the BMs to get.
   *  @param[out] pBatchModel       The BatchModel object.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetBatchModel(SQ_Project pProject, int iBMIndex, SQ_BatchModel *pBatchModel);

  /** @endcond // end of SQPPlus */

#ifdef _WIN32
#pragma pack(pop)
#endif

#ifdef __cplusplus
}
#endif /*__cplusplus*/


#endif /* _SQBATCHPROJECT_H_ */
