/*
Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
*/
#ifndef _SQBATCHVARIABLE_H_
#define _SQBATCHVARIABLE_H_

#include "SQDef.h"

/** @file SQBatchVariable.h

*/
#ifdef __cplusplus
extern "C" {
#endif 

#ifdef _WIN32
#pragma pack(push, 8)
#endif

#include "SQVariable.h"

  /** @cond SQPPlus */
   
      /**
   An enum defining the type and source of a variable.
   */
   typedef enum SQ_BatchVariableEnumType
   {
      SQ_Standard,                  /**< Default, not a batch Level variable */

      SQ_Batch_Condition,           /**< Batch condition variable */
      SQ_Duration,                  /**< The number of observations */
      SQ_Endpoint,                  /**< The last maturity/time value */
      SQ_Observation_Level_Scores,  /**< The values come from a score variable in the observation level dataset */
      SQ_Observation_Level_Rawdata, /**< The values come from the dataset in the observation level dataset */
      SQ_Summary_Min,               /**< The min of a specific variable */
      SQ_Summary_Max,               /**< The max of a specific variable */
      SQ_Summary_Mean,              /**< The mean of a specific variable */
      SQ_Summary_Median,            /**< The median of a specific variable */
      SQ_Summary_Stddev,            /**< The standard deviation of a specific variable */
      SQ_Summary_Robust_Stddev,     /**< The robust standard deviation of a specific variable */
      SQ_Summary_Interquartile,     /**< The interquartile of a specific variable */
      SQ_Summary_Slope,             /**< The slope of a specific variable using min square method. */
      SQ_Phase_Condition,           /**< Phase condition variable */
      SQ_Phase_Iteration_Condition  /**< Phase iteration condition variable */
   } SQ_BatchVariableType;

   /**
   A structure containing information about the origin of a batch level variable.
   */
   typedef struct SQ_VariableOriginType
   {
      SQ_BatchVariableType eVariableType; /**< The variable type */
      int iComponent;                     /**< The component if the variable type is OBSERVATION_LEVEL_SCORES */
      char* pszPhaseName;                 /**< The phase name where the variable is taken, UTF-8 encoded */
      int iPhaseNameLength;               /**< The length of the pszPhaseName buffer */
      float fMaturity;                    /**< The maturity */

   } SQ_VariableOrigin;

   /**
   *  Retrieves the variable origin info from a variable name in batch level dataset.
   *
   *  @param[in]  pVariable         The variable to get the name of.
   *  @param[out] pVariableOrigin   The variable origin info.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_GetVariableOrigin(SQ_Variable pVariable, SQ_VariableOrigin* pVariableOrigin);

  /** @endcond // end of SQPPlus */

#ifdef _WIN32
#pragma pack(pop)
#endif

#ifdef __cplusplus
}
#endif /*__cplusplus*/


#endif /* _SQBATCHVARIABLE_H_ */
