/*
Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
*/
#ifndef _SQMDATASET_H_
#define _SQMDATASET_H_

#include "SQDef.h"

/** @file SQMDataset.h

*/
#ifdef __cplusplus
extern "C" {
#endif 

#ifdef _WIN32
#pragma pack(push, 8)
#endif

#include "SQErrorCodes.h"
#include "SQDataset.h"
#include "SQCommon.h"
#include "SQStringMatrix.h"

   /// @cond SQM 
   
   /**
   *  Deletes observations from a dataset.
   *  Note: If there exists models for this dataset, those models will be deleted.
   *
   *  @param[in]   hDataset         The handle to the dataset
   *  @param[in]   hDSObsIndices    A vector containing the observation indices in the dataset that will be removed.
   *                                The vector must have at least one element.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_DeleteDatasetObservations(SQ_Dataset hDataset, SQ_IntVector hDSObsIndices);
   /**
   *  Deletes variables from a dataset.
   *  Note: If there exists models with these variables, those models will be deleted.
   *
   *  @param[in]   hDataset         The handle to the dataset
   *  @param[in]   hDSVarIndices    A vector containing the variable indices in the dataset that will be removed.
   *                                The vector must have at least one element.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_DeleteDatasetVariables(SQ_Dataset hDataset, SQ_IntVector hDSVarIndices);
   /**
   *  Adds a generated variable to a dataset.
   *
   *  @param[in]   hDataset         The handle to the dataset
   *  @param[in]   hVarNames        Matrix of the names for the generated variables and secondary IDs.
   *                                The names must be unique and must not be in the dataset prior to calling this function.
   *                                If NULL, then SQM will generate variable names, like v8, v9 if the dataset contained 7 variables before.
   *                                If v8 exist as a variable name when generating names like above, SQM will append 1 until it is unique, like v81, v9.
   *  @param[in]   szExpr           The generate variables expression. See documentation for expression format, UTF-8 encoded.
   *  @return                       Returns SQ_E_OK if success or an error code
   */
   SQCEXPORT SQ_ErrorCode SQCDECL SQ_AddGeneratedVariables(SQ_Dataset hDataset, SQ_StringMatrix* hVarNames, const char* szExpr);

   /// @endcond // end of SQM

#ifdef _WIN32
#pragma pack(pop)
#endif

#ifdef __cplusplus
}
#endif /*__cplusplus*/

#endif /* _SQMDATASET_H_ */
