/*
----------------------------------------------------------------------------

 Copyright (C) Sartorius Stedim Data Analytics AB 2017 -

 Use, modification and distribution are subject to the Boost Software
 License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)

----------------------------------------------------------------------------
*/

#ifndef _SQPPLUSRUNNER_H_
#define _SQPPLUSRUNNER_H_

#include <stdio.h>

#include "SIMCAQPPlus.h"

#ifdef __cplusplus
extern "C" {
#endif 

   typedef struct tagSQPBatchRunner
   {
      char* mszUSPName;
      SQ_Project mpProjHandle;
      int   mbIsBatchProject;

      /* Variables that are used if an input file is specified */
      SQ_StringVector mstrVariableNames;
      char* mszFileBuffer;
      unsigned int miFileNumCols;
      unsigned int miFileNumRows;
      int miPhaseColumn;
      int miPhases;
      /* Vector with the row numbers corresponding to each phase. */
      int* mpvecPhaseRows;
      int  miSizePhaseRows;

   } SQPBatchRunner;

   int SQPBatchRunner_Init(SQPBatchRunner* pObj, const char* szUSPName);
   void SQPBatchRunner_Run(SQPBatchRunner* pObj, FILE* pOut, FILE* pErr);
   void SQPBatchRunner_Destroy(SQPBatchRunner* pObj);

#ifdef __cplusplus
}
#endif /*__cplusplus*/

#endif
