/***************************************************************************/

/*
 *	linux/arch/m68knommu/platform/527x/config.c
 *
 *	Sub-architcture dependant initialization code for the Freescale
 *	5270/5271 CPUs.
 *
 *	Copyright (C) 1999-2004, Greg Ungerer (gerg@snapgear.com)
 *	Copyright (C) 2001-2004, SnapGear Inc. (www.snapgear.com)
 */

/***************************************************************************/

#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/param.h>
#include <linux/init.h>
#include <linux/interrupt.h>
#include <asm/dma.h>
#include <asm/traps.h>
#include <asm/machdep.h>
#include <asm/coldfire.h>
#include <asm/mcfsim.h>
#include <asm/mcfdma.h>

/***************************************************************************/

void coldfire_pit_tick(void);
void coldfire_pit_init(irqreturn_t (*handler)(int, void *, struct pt_regs *));
unsigned long coldfire_pit_offset(void);
void coldfire_trap_init(void);
void coldfire_reset(void);
#if defined(CONFIG_SAG_PR5800_CORE) ||defined(CONFIG_SAG_PR5410_CORE)	|| defined(CONFIG_SAG_PR5220_CORE)
void combix_mach_halt(void);
void combix_mach_poweroff(void);
#endif

/***************************************************************************/

/*
 *	DMA channel base address table.
 */
unsigned int   dma_base_addr[MAX_M68K_DMA_CHANNELS] = {
        MCF_MBAR + MCFDMA_BASE0,
};

unsigned int dma_device_address[MAX_M68K_DMA_CHANNELS];

/***************************************************************************/

void mcf_disableall(void)
{
	*((volatile unsigned long *) (MCF_IPSBAR + MCFICM_INTC0 + MCFINTC_IMRH)) = 0xffffffff;
	*((volatile unsigned long *) (MCF_IPSBAR + MCFICM_INTC0 + MCFINTC_IMRL)) = 0xffffffff;
}

/***************************************************************************/

void mcf_autovector(unsigned int vec)
{
	/* Everything is auto-vectored on the 5272 */
}

#if defined(CONFIG_INPUT_M68K_BEEP)  && defined(CONFIG_SAG_PR5800_CORE) 
void sag_mksound(int count , int p)
{
	printk("mach_beep %d\n",count);	
}
#endif

/***************************************************************************/

void config_BSP(char *commandp, int size)
{
	mcf_disableall();
#if defined(CONFIG_SAG_PR5800_CORE)
	/* enable interrupt irq7 for powerfail detection during boot
	** the vector is linked to bios at this moment */
	*(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRL) &= ~((1 << (7)) | 1);
#endif
#ifdef CONFIG_BOOTPARAM
	strncpy(commandp, CONFIG_BOOTPARAM_STRING, size);
	commandp[size-1] = 0;
#else
	memset(commandp, 0, size);
#endif

	mach_sched_init = coldfire_pit_init;
	mach_tick = coldfire_pit_tick;
	mach_gettimeoffset = coldfire_pit_offset;
	mach_trap_init = coldfire_trap_init;
	mach_reset = coldfire_reset;

#if defined(CONFIG_INPUT_M68K_BEEP)  && defined(CONFIG_SAG_PR5800_CORE) 
	mach_beep  = sag_mksound;
#endif
#if defined(CONFIG_SAG_PR5800_CORE) || defined(CONFIG_SAG_PR5410_CORE)|| defined(CONFIG_SAG_PR5220_CORE)
	mach_halt = combix_mach_halt;
	mach_power_off = combix_mach_poweroff;
#endif

}

#if defined(CONFIG_SAG_PR5410_CORE)|| defined(CONFIG_SAG_PR5220_CORE)
/// jump to bios and switch power off
void combix_mach_poweroff(void)
{
struct timeval ktv;
int mode=2;

	/* disable all interrupts */
	*(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRL) |= 1;	// mask all interrupts

	asm(" lea       %0,%%a0\n"
	    " lea	%1,%%a1\n"
	    " move.w	%%sr,%%d0\n"
	    " move.l	#0x2700,%%d1\n"
	    " move.w	%%d1,%%sr\n"
	    " lea -15*4(%%sp),%%sp \n"
	    " movem.l %%d0-%%d7/%%a0-%%a6,(%%sp) \n"
	    " jsr 0xF0000406 \n"           
	    " movem.l (%%sp),%%d0-%%d7/%%a0-%%a6 \n" 
	    " lea 15*4(%%sp),%%sp \n"            
	    " move.w	%%d0,%%sr\n"
	    :
	    : "m"(ktv),"m"(mode)
	    : "%d0","%d1","%a0","%a1"
	   );
}

/// jump to bios main routine 
void combix_mach_halt(void)
{
struct timeval ktv;
int mode=1;

	/* disable all interrupts */
	*(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRL) |= 1;	// mask all interrupts
	
	asm(" lea       %0,%%a0\n"
	    " lea	%1,%%a1\n"
	    " move.w	%%sr,%%d0\n"
	    " move.l	#0x2700,%%d1\n"
	    " move.w	%%d1,%%sr\n"
	    " lea -15*4(%%sp),%%sp \n"
	    " movem.l %%d0-%%d7/%%a0-%%a6,(%%sp) \n"
	    " jsr 0xF0000406 \n"           
	    " movem.l (%%sp),%%d0-%%d7/%%a0-%%a6 \n" 
	    " lea 15*4(%%sp),%%sp \n"            
	    " move.w	%%d0,%%sr\n"
	    :
	    : "m"(ktv),"m"(mode)
	    : "%d0","%d1","%a0","%a1"
	   );
}
#endif
/***************************************************************************/
