/***************************************************************************/

/*
 *	linux/arch/m68knommu/platform/5282/dma_timer.c
 *
 *	Sub-architcture dependant dma timer code for the Motorola
 *	5282 and 5270 CPU.
 *
 *	Copyright (C) 2005, Andreas Horn (andreas.horn@sartorius.com)
 */

/***************************************************************************/
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <asm/dma.h>
#include <asm/mcf528x_dma_timer.h>
#if defined(CONFIG_M527x)||defined(CONFIG_M528x)
/*
 * DMA timer channel base address
*/
struct S_MCF_DMA_TIMER* dma_timer[MAX_M68K_DMA_CHANNELS];

spinlock_t t_lock = SPIN_LOCK_UNLOCKED;

struct S_MCF_DMA_TIMER* request_hrt_timer(int *intr_request_vector)
{
	int i;
	BYTE_REG *cp;
	spin_lock(t_lock);
	for(i=0;i<MAX_M68K_DMA_CHANNELS;i++)
	{
#if defined(CONFIG_SAG_PR5800_CORE)
		if(i==1) continue;	// reserved by keyboard click in bios
#endif
		if(!dma_timer[i])
		{
			dma_timer[i] =  & MCF_DMA_TIMER(i);
			spin_unlock(t_lock);
			*intr_request_vector = MCFDTIM0_IRQ_INT+i;
			// one time initialisation of high resolution timer
			MCF_DMA_TIMER(i).dtmr=DTMR_PS(MCF_BUSCLK/(1000*1000))	// prescale at maximum speed
			                   |DTMR_CE_NONE	// capture no edge
			                   |DTMR_OM_0	// output mode pulse (dont care)
			                   |DTMR_ORRI_0	// disable interrupt
			                   |DTMR_FRR_0	// free run timer, dont reset at reference value
			                   |DTMR_CLK_DIV1	// clock is system/1
			                   |DTMR_RST_1;	// enable timer
			MCF_DMA_TIMER(i).dtxmr=DTXMR_DMAEN_0	// no dma request on reference match
			                    |DTXMR_MODE16_0;	// dont use 16bit mode
			cp = (BYTE_REG*)(MCF_MBAR + MCFICM_INTC0+ MCFINTC_ICR0 + MCFDTIM0_IRQ_INT+i);
			// no interrupt prorities must set twice !!!!!!! see Manual 13-11
			*cp = 044+i;         /* (octal)autovector on, il=4, ip=4+channel     */

#if defined(CONFIG_M527x)
			MCF_INTC0_IMRL &= ~((1 << (MCFDTIM0_IRQ_INT+i)) | 1);
#endif
#if defined(CONFIG_M532x)
			MCF_INTC0_IMRH &= ~(1 << (MCFDTIM0_IRQ_INT+i-32)) ;
#endif

			return dma_timer[i];
		}
	}
	spin_unlock(t_lock);
	printk(KERN_ERR "no more free dma timer\n");
	return 0;
}

void release_hrt_timer(struct S_MCF_DMA_TIMER* timer)
{
	int i;
	spin_lock(t_lock);
	for(i=0;i<MAX_M68K_DMA_CHANNELS;i++)
	{
		if(dma_timer[i] == timer)
		{
			dma_timer[i] =0;
#if defined(CONFIG_M532x)
			MCF_INTC0_IMRH |=((1 << (MCFDTIM0_IRQ_INT+i-32)));
#endif
			spin_unlock(t_lock);
			return;
		}
	}
	spin_unlock(t_lock);
	printk(KERN_ERR "can't relase dma timer %8lx\n",(long)timer);
}

void reinit_hrt_timer(struct S_MCF_DMA_TIMER* timer)
{
	BYTE_REG *cp;
	int i;
	for(i=0;i<MAX_M68K_DMA_CHANNELS;i++)
	{
		if(dma_timer[i] == timer)
		{
			timer->dtmr=DTMR_PS(MCF_BUSCLK/(1000*1000))	// prescale at maximum speed
						|DTMR_CE_NONE	// capture no edge
						|DTMR_OM_0	// output mode pulse (dont care)
						|DTMR_ORRI_0	// disable interrupt
						|DTMR_FRR_0	// free run timer, dont reset at reference value
						|DTMR_CLK_DIV1	// clock is system/1
						|DTMR_RST_1;	// enable timer
			timer->dtxmr=DTXMR_DMAEN_0		// no dma request on reference match
						|DTXMR_MODE16_0;	// dont use 16bit mode
			cp = (BYTE_REG*)(MCF_MBAR + MCFICM_INTC0+ MCFINTC_ICR0 + MCFDTIM0_IRQ_INT+i);
			// no interrupt prorities must set twice !!!!!!! see Manual 13-11
			*cp = 044+i;         /* (octal)autovector on, il=4, ip=4+channel     */
			return;
		}
	}
}

void start_hrt_timer(struct S_MCF_DMA_TIMER* timer,unsigned long delay)
{
	timer->dtrr=delay;
	timer->dtcn=0;			/* clear count register */
	timer->dter = 3;		/* clear pending interrupt */
	timer->dtmr|=DTMR_ORRI_1;	/* start timer */
}
void stop_hrt_timer(struct S_MCF_DMA_TIMER* timer)
{
	timer->dter = 3;		/* clear pending interrupt */
	timer->dtmr&=~DTMR_ORRI_1;	/* stop timer */
}

#endif

