/*
 * Sartorius Combix Power Management Routines
 *
 * Copyright (c) 2005 Andreas Horn <andreas.horn@sartorius.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 *
 * History:
 *
 */
#include <linux/init.h>
#include <linux/suspend.h>
#include <linux/errno.h>
#include <linux/time.h>
#include <linux/syscalls.h>
#include <asm/traps.h>

#include <asm/irq.h>
#include <asm/system.h>
#include <asm/coldfire.h>
#include <asm/mcfsim.h>
#include <asm/mcfpit.h>
#include <asm/mcfedgeport.h>

/*
 *	Define the watchdog vector.
 */
#define	MCFINT_POWERFAIL	7	// INTSRC
#define MCFINTC0_BASEVEC       64
#define IRQ_POWERFAIL (MCFINTC0_BASEVEC+MCFINT_POWERFAIL)

//#define DSP_BUFFER_SIZE 0x14000
//static unsigned char dsp_buffer[DSP_BUFFER_SIZE];
#define DSP_BASE 0xA0000000
#define DSP_GPO_REG 0xAD
#define DSP_GPIO_REG 0xAC
#define DSP_PWM_REG 0xB0
#define DSP_BUFF 0x00020000
#define PAR_BUSCTL 0x100042

extern void power_interrupt(void);
#if 0
//============================================================
// Chapter 18 : DMA Controller Module
//============================================================

typedef volatile unsigned char  BYTE_REG;
typedef volatile unsigned short WORD_REG;
typedef volatile unsigned long  LONG_REG;
struct S_MCF_DMACM
{
	LONG_REG sar;	//+0x0100	Source Adress Register
	LONG_REG dar;	//+0x0104	Destination Address Register
	LONG_REG dsr_bcr;	//
	LONG_REG dcr;
};
enum E_DSR
{
	DSR_CE=1<<(6+24),	// configuration error
	DSR_BES=1<<(5+24),	// Bus Error on source
	DSR_BED=1<<(4+24),	// Bus Error on dest
	DSR_REQ=1<<(2+24),	// request is pending
	DSR_BSY=1<<(1+24),	// resgest is active
	DSR_DONE=1<<(0+24)	// transfer is done
};
enum E_DCR
{
	DCR_INT_0=0<<31,
	DCR_INT_1=1<<31,
	DCR_EEXT_0=0<<30,
	DCR_EEXT_1=1<<30,
	DCR_CS_0=0<<29,
	DCR_CS_1=1<<29,
	DCR_AA_0=0<<28,
	DCR_AA_1=1<<28,
	DCR_BWC_0=0<<25,
	DCR_BWC_16k=1<<25,
	DCR_SINC_0=0<<22,
	DCR_SINC_1=1<<22,
	DCR_SSIZE_LONG=0<<20,
	DCR_SSIZE_BYTE=1<<20,
	DCR_SSIZE_WORD=2<<20,
	DCR_SSIZE_LINE=3<<20,
	DCR_DINC_0=0<<19,
	DCR_DINC_1=1<<19,
	DCR_DSIZE_LONG=0<<17,
	DCR_DSIZE_BYTE=1<<17,
	DCR_DSIZE_WORD=2<<17,
	DCR_DSIZE_LINE=3<<17,
	DCR_START_1=1<<16,
	DCR_SMOD_none=0<<12,
	DCR_DMOD_none=0<<8,
	DCR_D_REQ_0=0<<7,
	DCR_LINKCC_0=0<<4,
	DCR_LCH1_0=0<<2,
	DCR_LCH2_0=0<<0,
};

#define MCF_DMA0 (*(struct S_MCF_DMACM*)(MCF_MBAR+0x0100))
#define MCF_DMA1 (*(struct S_MCF_DMACM*)(MCF_MBAR+0x0140))
#define MCF_DMA2 (*(struct S_MCF_DMACM*)(MCF_MBAR+0x0180))
#define MCF_DMA3 (*(struct S_MCF_DMACM*)(MCF_MBAR+0x01C0))
#endif

int power_down_activ=0;


extern void combix_cpu_suspend(void);
extern void combix_cpu_resume(void);
extern void coldfire_restore_pit_after_powerfail(void);
irqreturn_t powerfail_intr(int irq, void *dummy, struct pt_regs *fp);

#define PCSR_INIT (MCFPIT_PCSR_EN | MCFPIT_PCSR_PIE | MCFPIT_PCSR_OVW |	MCFPIT_PCSR_RLD | MCFPIT_PCSR_CLK64)



static u32 imrh,imrl;
/// have a powerfail, jump into bios and store the image in Nandflash
static int combix_pm_enter(suspend_state_t state)
{
volatile struct mcfpit *tp;
struct timeval ktv;
int mode=0;

	imrl = *(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRL);
	imrh = *(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRH);

	*(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRL) |= 1;	// mask all interrupts

	/* disable system timer */
	tp = (volatile struct mcfpit *) (MCF_IPSBAR + MCFPIT_BASE1);
	tp->pcsr = MCFPIT_PCSR_DISABLE;

	asm(" lea       %0,%%a0\n"
	    " lea	%1,%%a1\n"
	    " move.w	%%sr,%%d0\n"
	    " move.l	#0x2700,%%d1\n"
	    " move.w	%%d1,%%sr\n"
	    " lea -15*4(%%sp),%%sp \n"
	    " movem.l %%d0-%%d7/%%a0-%%a6,(%%sp) \n"
	    " jsr 0xF0000406 \n"
	    " movem.l (%%sp),%%d0-%%d7/%%a0-%%a6 \n"
	    " lea 15*4(%%sp),%%sp \n"
	    " move.w	%%d0,%%sr\n"
	    :
	    : "m"(ktv),"m"(mode)
	    : "%d0","%d1","%a0","%a1"
	   );

	// setup chip select for i/o slots external TA
	*(volatile unsigned short*)(0x400000c6) = 0x0040;


	*(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRL)  &= ~((1 << 7) | 1);

	power_down_activ=0;	// enable tputs to BIOS

	return 0;
}

/// jump to bios main routine
void combix_mach_halt(void)
{
volatile struct mcfpit *tp;
struct timeval ktv;
int mode=1;

	/* disable all interrupts but except irq7 */
	*(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRL) |= 1;	// mask all interrupts
	*(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRL)  &= ~((1 << 7) | 1);


	/* Set up PIT timer 1 as poll clock */
	tp = (volatile struct mcfpit *) (MCF_IPSBAR + MCFPIT_BASE1);
	tp->pcsr = MCFPIT_PCSR_DISABLE;
	asm(" lea       %0,%%a0\n"
	    " lea	%1,%%a1\n"
	    " move.w	%%sr,%%d0\n"
	    " move.l	#0x2700,%%d1\n"
	    " move.w	%%d1,%%sr\n"
	    " lea -15*4(%%sp),%%sp \n"
	    " movem.l %%d0-%%d7/%%a0-%%a6,(%%sp) \n"
	    " jsr 0xF0000406 \n"
	    " movem.l (%%sp),%%d0-%%d7/%%a0-%%a6 \n"
	    " lea 15*4(%%sp),%%sp \n"
	    " move.w	%%d0,%%sr\n"
	    :
	    : "m"(ktv),"m"(mode)
	    : "%d0","%d1","%a0","%a1"
	   );
}

/// jump to bios and switch power off
void combix_mach_poweroff(void)
{
struct timeval ktv;
int mode=2;

	/* disable all interrupts but except irq7 */
	*(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRL) |= 1;	// mask all interrupts
	*(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRL)  &= ~((1 << 7) | 1);

	asm(" lea       %0,%%a0\n"
	    " lea	%1,%%a1\n"
	    " move.w	%%sr,%%d0\n"
	    " move.l	#0x2700,%%d1\n"
	    " move.w	%%d1,%%sr\n"
	    " lea -15*4(%%sp),%%sp \n"
	    " movem.l %%d0-%%d7/%%a0-%%a6,(%%sp) \n"
	    " jsr 0xF0000406 \n"
	    " movem.l (%%sp),%%d0-%%d7/%%a0-%%a6 \n"
	    " lea 15*4(%%sp),%%sp \n"
	    " move.w	%%d0,%%sr\n"
	    :
	    : "m"(ktv),"m"(mode)
	    : "%d0","%d1","%a0","%a1"
	   );
}


/*
 * Called after processes are frozen, but before we shut down devices.
 */
static int combix_pm_prepare(suspend_state_t state)
{
	return 0;
}

/*
 * Called after devices are re-setup, but before processes are thawed.
 */
static int combix_pm_finish(suspend_state_t state)
{
	// restore powerfail interrupt
	*(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRL) = imrl;
	*(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRH) = imrh;

	// restart the system timer
	coldfire_restore_pit_after_powerfail();
	/* enable powerfail interrupt irq 7 */
	//enable_edgeport(7,FALLING_MODE,powerfail_intr);
	*(volatile unsigned long *) (MCF_MBAR+MCFICM_INTC0+MCFINTC_IMRL)  &= ~((1 << 7) | 1);
	return 0;
}
/***************************************************************************/
/*
 *	Process a powerfail interrupt.
 */
irqreturn_t powerfail_intr(int irq, void *dummy, struct pt_regs *fp)
{
//	struct task_struct *g, *p;
        *(volatile unsigned char *)(MCF_IPSBAR + MCFICM_INTC0 + MCFINTC_INTFRCL + 3)=0; // remove force inter
	*(volatile unsigned char *)(MCF_MBAR+MCF_EPIER) &=~(1<<MCFINT_POWERFAIL);// disable irq 7
 	// disable possible interrupts from a option card
	*(volatile unsigned char *)(MCF_MBAR+MCF_EPIER) &=~0x0e;	// disable irq 1..3
	*(volatile unsigned char *)(MCF_MBAR + MCF_EPFR) = 1<<MCFINT_POWERFAIL; /* reset interrupt */
        *(volatile unsigned char *)(DSP_BASE+DSP_PWM_REG)&=~0xF0; 	// force PWM off
	*(volatile unsigned char *)(DSP_BASE+DSP_GPO_REG)=0x00;		// force display GPO low
	*(volatile unsigned char *)(DSP_BASE+DSP_GPIO_REG)=0x06;	// force display GPO low

	*(volatile unsigned long *)(MCF_IPSBAR + MCFICM_INTC0 + MCFINTC_IMRH)|= (1 << (MCFINT_PIT2 - 32));

	power_down_activ=1;	// disable outputs to BIOS
	*(volatile unsigned char *)(MCF_MBAR + MCF_GPIO_PODR_TIMER) |= 0x10;	// disable output signals
	*(volatile unsigned char *)(MCF_MBAR + MCF_GPIO_PODR_TIMER) &=~2;	// swiosi off
	// setup chip select for Display to internal TA
	// will be set default by bios
	*(volatile unsigned short*)(0x400000ae) = 0x3d80;
	// setup chip select for i/o slots internal TA
	*(volatile unsigned short*)(0x400000c6) = 0x3d40;
	// wg. hardware bug, kommt kurzeitig nach poweron
	*(volatile unsigned short*)(PAR_BUSCTL) &=~(1<<12);	// TA is GPIO

	/* signal to power driver */
	power_interrupt();

//	free_irq(MCFINTC0_BASEVEC+7,0);
#if 0
	do_each_thread(g, p) {
		if(strcmp(p->comm,"powerd")==0) {
			/* signal to powerd process power is down, we are running now on battery */
			kill_proc(p->pid, SIGPWR,1);
			break;
		}
	} while_each_thread(g, p);
#endif
	return IRQ_NONE;
}

/*
 * Set to PM_DISK_FIRMWARE so we can quickly veto suspend-to-disk.
 */
static struct pm_ops combix_pm_ops = {
	.pm_disk_mode	= PM_DISK_FIRMWARE,
	.prepare	= combix_pm_prepare,
	.enter		= combix_pm_enter,
	.finish		= combix_pm_finish,
};

static int __init combix_pm_init(void)
{
	pm_set_ops(&combix_pm_ops);
	return 0;
}

late_initcall(combix_pm_init);

