/***************************************************************************/

/*
 *	linux/arch/m68knommu/platform/527x/config.c
 *
 *	Sub-architcture dependant initialization code for the Freescale
 *	5270/5271 CPUs.
 *
 *	Copyright (C) 1999-2004, Greg Ungerer (gerg@snapgear.com)
 *	Copyright (C) 2001-2004, SnapGear Inc. (www.snapgear.com)
 */

/***************************************************************************/

#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/param.h>
#include <linux/init.h>
#include <linux/interrupt.h>
#include <asm/dma.h>
#include <asm/traps.h>
#include <asm/machdep.h>
#include <asm/coldfire.h>
#include <asm/mcfsim.h>
#include <asm/mcfdma.h>

//JJvB cleanup, because this is only used for Cobra/Labpro
/***************************************************************************/

void coldfire_pit_tick(void);
void coldfire_pit_init(irqreturn_t (*handler)(int, void *, struct pt_regs *));
unsigned long coldfire_pit_offset(void);
void coldfire_trap_init(void);
void coldfire_reset(void);

/***************************************************************************/

/*
 *	DMA channel base address table.
 */
//unsigned int   dma_base_addr[MAX_M68K_DMA_CHANNELS] = {
//	MCF_MBAR + MCFDMA_BASE0,
//};

//unsigned int dma_device_address[MAX_M68K_DMA_CHANNELS];

/***************************************************************************/

void mcf_disableall(void)
{
	MCF_INTC0_SIMR = 0x40;	// set all masks
	MCF_INTC1_SIMR = 0x40;	// set all masks
}

/***************************************************************************/

void mcf_autovector(unsigned int vec)
{
	/* Everything is auto-vectored on the 5272 */
}

#if defined(CONFIG_INPUT_M68K_BEEP)  && defined(CONFIG_SAG_PR5800_CORE)
void sag_mksound(int count , int p)
{
	printk("mach_beep %d\n",count);
}
#endif

void mcf_trigger_wdg(int notused)
{
	// trigger the watchdog (no harm, if not activated)
	MCF_WTM_WSR=0x5555;
	MCF_WTM_WSR=0xAAAA;
}

/***************************************************************************/

void config_BSP(char *commandp, int size)
{
	mcf_disableall();
#if defined(CONFIG_SAG_COBRA_CORE) || defined(CONFIG_SAG_LABPRO_CORE)
	/* enable interrupt irq7 for buserror detection */
	MCF_INTC0_CIMR=7;
#endif

#ifdef CONFIG_BOOTPARAM
	strncpy(commandp, CONFIG_BOOTPARAM_STRING, size);
	commandp[size-1] = 0;
#else
	memset(commandp, 0, size);
#endif

	mach_sched_init = coldfire_pit_init;
	mach_tick = coldfire_pit_tick;
	mach_gettimeoffset = coldfire_pit_offset;
	mach_trap_init = coldfire_trap_init;
	mach_reset = coldfire_reset;

#if defined(CONFIG_INPUT_M68K_BEEP)  && defined(CONFIG_SAG_PR5800_CORE)
	mach_beep  = sag_mksound;
#endif

}

/***************************************************************************/
void sysinit(void)
{
	// all done from bios
}
