#ifndef SAG_KEYB_INCLUDE
#define SAG_KEYB_INCLUDE

#define MAX_NR_VTTY 8
#define RX_BUF_SIZE 128		/* must be 16,32,64,128... */

#define SUCCESS 1
#define TIMEOUT 2

/*							*/
/* Keypad keys						*/
/*							*/

#define	SKEY_PF1	256
#define	SKEY_PF2	257
#define	SKEY_PF3	258
#define	SKEY_PF4	259
#define	SKEY_KP0	260
#define	SKEY_KP1	261
#define	SKEY_KP2	262
#define	SKEY_KP3	263
#define	SKEY_KP4	264
#define	SKEY_KP5	265
#define	SKEY_KP6	266
#define	SKEY_KP7	267
#define	SKEY_KP8	268
#define	SKEY_KP9	269
#define	SKEY_ENTER 270
#define	SKEY_MINUS 271
#define	SKEY_COMMA 272
#define	SKEY_PERIOD 273

/*							*/
/* Cursor positioning keys				*/
/*							*/

#define	SKEY_UP 274
#define	SKEY_DOWN 275
#define	SKEY_LEFT 276
#define	SKEY_RIGHT 277

/*							*/
/* Function keys					*/
/*							*/

#define	SKEY_F1 281
#define	SKEY_F2 282
#define	SKEY_F3 283
#define	SKEY_F4 284
#define	SKEY_F5 285
#define	SKEY_F6 286
#define	SKEY_F7 287
#define	SKEY_F8 288
#define	SKEY_F9 289
#define	SKEY_F10	290
#define	SKEY_F11	291
#define	SKEY_F12	292
#define	SKEY_F13	293
#define	SKEY_F14	294
#define	SKEY_F15	295
#define	SKEY_F16	296
#define	SKEY_F17	297
#define	SKEY_F18	298
#define	SKEY_F19	299
#define	SKEY_F20	300
/*							*/
/* Synonyms for	function keys				*/
/*							*/
#define	SKEY_HELP 295
#define	SKEY_DO 296
/*							*/
/* Editing keys						*/
/*							*/
#define	SKEY_E1 311		/* FIND			*/
#define	SKEY_E2 312		/* INSERT_HERE		*/
#define	SKEY_E3 313		/* REMOVE		*/
#define	SKEY_E4 314		/* SELECT		*/
#define	SKEY_E5 315		/* PREV_SCREEN		*/
#define	SKEY_E6 316		/* NEXT_SCREEN		*/
/*							*/
/* Synonyms for	editing	keys				*/
/*							*/
#define	SKEY_FIND 	311	/* E1			*/
#define	SKEY_INSERT_HERE	312	/* E2			*/
#define	SKEY_REMOVE 	313	/* E3			*/
#define	SKEY_SELECT 	314	/* E4			*/
#define	SKEY_PREV_SCREEN	315	/* E5			*/
#define	SKEY_NEXT_SCREEN	316	/* E6			*/

#define SKEY_HOME 	317	/* only on PC keyboards */
#define SKEY_END	318	/* only on PC keyboards */
#define SKEY_POWERFAIL	499	/* set on poweron */
/*
 * This is our internal structure for each serial port's state.
 * Each serial port has one of these structures associated with it.
 */

struct kb_private {
	int			magic;
	int			open_count;
	struct tty_struct 	*tty;
	struct work_struct	tqueue;
};

extern struct kb_private v_tty_data[MAX_NR_VTTY];

struct keyb_info {
	spinlock_t     lock;
	struct tty_struct *tty;
	unsigned long rx_buf[RX_BUF_SIZE];
	int	wr_pos;			/* next write to this position */
	int	rd_pos;
	int	count;
	struct semaphore sem;
	unsigned int state;
	unsigned char flags;
	struct timer_list tmr;
};

#endif
