/*
**  device for enabling the powerfail handling only
*/

#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/fs.h>
#include <linux/fcntl.h>
#include <linux/module.h>
#include <asm/irq.h>
#include <asm/traps.h>
#include <asm/mcfedgeport.h>

#if CONFIG_MODVERSIONS==1
#define MODVERSIONS
#include <linux/modversions.h>
#endif

#define POWER_MAJOR 125		/* major device mumber */

/* struct wait_queue *wqueue;   */
static DECLARE_WAIT_QUEUE_HEAD(wqueue);  

static int power_open(struct inode *inode, struct file *file);
static int power_release(struct inode *inode, struct file *file);
static int power_ioctl(struct inode *inode, struct file *file,
				unsigned int cmd, unsigned long arg);

extern irqreturn_t powerfail_intr(int irq, void *dummy, struct pt_regs *fp);

static struct file_operations power_ops = {
	owner:		THIS_MODULE,
	ioctl:		power_ioctl,
	open:		power_open,
	release:	power_release  /* a.k.a. close */
};

extern e_vector	*_ramvec;
asmlinkage void inthandler(void);
int powercnt=0;

static int power_open(struct inode *inode, struct file *file)
{
	_ramvec[64+7] = inthandler;
	if(enable_edgeport(7,FALLING_MODE,powerfail_intr)<0)
		printk( "%s(%d):Cant request interrupt, IRQ=71\n",
			__FILE__,__LINE__);
	return 0;
}

static int power_release(struct inode *inode, struct file *file)
{
	return 0;
}

static int power_ioctl(struct inode *inode, struct file *file,
			unsigned int cmd, unsigned long arg)
{
	if(!powercnt)
		interruptible_sleep_on(&wqueue);
	if(!powercnt) return -EIO;
	powercnt=0;
	return 0;
}

void power_interrupt(void)
{
	powercnt++;
	wake_up(&wqueue);	/* transfer finished */
}

/* init for compiled-in driver: call from mem.c */
int __init power_dev_init(void)                                  /* the __init added by ron  */
{
	if (register_chrdev(POWER_MAJOR, "power", &power_ops)) {
		printk(KERN_NOTICE "Can't allocate major number %d for Power devices.\n",
		       POWER_MAJOR);
		return -EAGAIN;;
	}
        printk ("Sartorius Power device driver installed\n");
	return 0;
}


module_init(power_dev_init); 

MODULE_LICENSE("GPL");
MODULE_SUPPORTED_DEVICE("power");
MODULE_DESCRIPTION("Direct character-device access to power control device");
