/*
 *	mmc_crc16.h - CRC-16 routine
 *
 * Implements the standard CRC-16:
 *   Width 16
 *   Poly  0x8005 (x^16 + x^15 + x^2 + 1)
 *   Init  0
 *
 * Copyright (c) 2005 Ben Gardner <bgardner@wabtec.com>
 *
 * This source code is licensed under the GNU General Public License,
 * Version 2. See the file COPYING for more details.
 */

#ifndef __MMC_CRC16_H
#define __MMC_CRC16_H

#include <linux/types.h>

extern u16 const mmc_crc16_table[256];

extern u16 mmc_crc16(u16 crc, const u8 *buffer, size_t len);

static inline u16 mmc_crc16_byte(u16 crc, const u8 data)
{
	return (mmc_crc16_table[((crc>>8) ^ data) & 0xFF] ^(crc << 8))&0xFFFF;
}

#endif /* __MMC_CRC16_H */

