/*
 * Flash memory access on COBRA5329
 *
 * $Id: sag_flash.h,v 0.00 2007/04/03 13:44:46 dec3ban Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef SAG_FLASH_H
#define SAG_FLASH_H

typedef volatile unsigned long  LONG_REG;

typedef enum {

	MCF_ACRX_ADDR_BASE_BITS	 = 0xFF000000,
	MCF_ACRX_ADDR_MASK_SHIFT = 8,
	MCF_ACRX_ADDR_MASK_BITS  = 0x00FF0000,
	MCF_ACRX_ENABLE			 = 0x00008000,

	MCF_ACRX_SUP_MODE_BITS   = 0x00006000,
	MCF_ACRX_SUP_MODE_USER   = 0x00000000,
	MCF_ACRX_SUP_MODE_SUP    = 0x00002000,
	MCF_ACRX_SUP_MODE_BOTH1  = 0x00004000,
	MCF_ACRX_SUP_MODE_BOTH2  = 0x00006000,
	
	MCF_ACRX_CACH_MODE_BITS  = 0x00000060,
	MCF_ACRX_CACH_WR_THROUGH = 0x00000000,
	MCF_ACRX_CACH_COPYBACK   = 0x00000020,
	MCF_ACRX_CACH_PRECISE    = 0x00000040,
	MCF_ACRX_CACH_IMPRECISE  = 0x00000060,

	MCF_ACRX_WRITE_PROTECT  = 0x00000002

} T_MCF_ACRX;

/****************************************************************************/

typedef enum {BAM_WP = (1<<8)} WP; 	/* write protect										*/

typedef struct S_MCF_CSM_CS
{
	/* registers */
	LONG_REG ar;				/* AddressRegister really a short, but low word is ignored  */
	LONG_REG mr;				/* MaskRegister 											*/
	LONG_REG cr;				/* Control Register 										*/
} T_MCF_CSM_CS;

typedef struct S_MCF_CSM
{
	T_MCF_CSM_CS cs0;	// 0xFC008000
	T_MCF_CSM_CS cs1;	// 0xFC00800C
	T_MCF_CSM_CS cs2;	// 0xFC008018
	T_MCF_CSM_CS cs3;	// 0xFC008024
	T_MCF_CSM_CS cs4;	// 0xFC008030
	T_MCF_CSM_CS cs5;	// 0xFC00803C
} T_MCF_CSM;

#define MCF_CSM (*(T_MCF_CSM*)(0xFC008000))

#endif /* SAG_FLASH_H */

