/*
 *	m527xi2c.h -- ColdFire 527x/528x i2c controller support.
 */
#ifndef M527X_I2C_H
#define M527X_I2C_H

#if defined (CONFIG_M527x)
/* Register read/write macros */
#define MCF_I2AR     *(volatile unsigned char *)(MCF_MBAR + 0x0300) 	/* I2C Address 		 */
#define MCF_I2FDR    *(volatile unsigned char *)(MCF_MBAR + 0x0304)	/* I2C Frequency Divider */
#define MCF_I2CR     *(volatile unsigned char *)(MCF_MBAR + 0x0308)	/* I2C Control		 */
#define MCF_I2SR     *(volatile unsigned char *)(MCF_MBAR + 0x030C)	/* I2C Status		 */
#define MCF_I2DR     *(volatile unsigned char *)(MCF_MBAR + 0x0310)	/* I2C Data I/O		 */
#endif
#if defined (CONFIG_M532x)
/* Register read/write macros */
#define MCF_I2AR     *(volatile unsigned char *)(0xFC058000) 	/* I2C Address 		 */
#define MCF_I2FDR    *(volatile unsigned char *)(0xFC058004)	/* I2C Frequency Divider */
#define MCF_I2CR     *(volatile unsigned char *)(0xFC058008)	/* I2C Control		 */
#define MCF_I2SR     *(volatile unsigned char *)(0xFC05800C)	/* I2C Status		 */
#define MCF_I2DR     *(volatile unsigned char *)(0xFC058010)	/* I2C Data I/O		 */
#endif

/* Bit definitions and macros for MCF_I2C_I2AR */
#define MCF_I2AR_ADR(x)    (((x)&0x7F)<<1)

/* Bit definitions and macros for MCF_I2C_I2FDR */
#define MCF_I2FDR_IC(x)    (((x)&0x3F)<<0)

/* some predefined divider values (see table in reference manual) */


#define MCF_I2FDR_IC_20 0x20
#define MCF_I2FDR_IC_22 0x21
#define MCF_I2FDR_IC_24 0x22
#define MCF_I2FDR_IC_26 0x23
#define MCF_I2FDR_IC_28 0x24
#define MCF_I2FDR_IC_30 0x01
#define MCF_I2FDR_IC_32 0x25
#define MCF_I2FDR_IC_34 0x02
#define MCF_I2FDR_IC_36 0x26
#define MCF_I2FDR_IC_40 0x27
#define MCF_I2FDR_IC_44 0x04
#define MCF_I2FDR_IC_48 0x28
#define MCF_I2FDR_IC_56 0x29
#define MCF_I2FDR_IC_64 0x2A
#define MCF_I2FDR_IC_68 0x07
#define MCF_I2FDR_IC_72 0x2B
#define MCF_I2FDR_IC_80 0x2C
#define MCF_I2FDR_IC_88 0x09
#define MCF_I2FDR_IC_96 0x2D
#define MCF_I2FDR_IC_104 0x0A
#define MCF_I2FDR_IC_112 0x2E
#define MCF_I2FDR_IC_128 0x2F
#define MCF_I2FDR_IC_144 0x0C
#define MCF_I2FDR_IC_160 0x30
#define MCF_I2FDR_IC_192 0x31
#define MCF_I2FDR_IC_224 0x32
#define MCF_I2FDR_IC_240 0x0F
#define MCF_I2FDR_IC_256 0x33
#define MCF_I2FDR_IC_288 0x10
#define MCF_I2FDR_IC_320 0x34
#define MCF_I2FDR_IC_384 0x35
#define MCF_I2FDR_IC_448 0x36
#define MCF_I2FDR_IC_480 0x13
#define MCF_I2FDR_IC_512 0x37
#define MCF_I2FDR_IC_576 0x14
#define MCF_I2FDR_IC_640 0x38
#define MCF_I2FDR_IC_768 0x39
#define MCF_I2FDR_IC_896 0x3A
#define MCF_I2FDR_IC_960 0x17
#define MCF_I2FDR_IC_1024 0x3B
#define MCF_I2FDR_IC_1152 0x18
#define MCF_I2FDR_IC_1280 0x3C
#define MCF_I2FDR_IC_1536 0x1A
#define MCF_I2FDR_IC_1792 0x3E
#define MCF_I2FDR_IC_1920 0x1B
#define MCF_I2FDR_IC_2048 0x3F
#define MCF_I2FDR_IC_2304 0x1C
#define MCF_I2FDR_IC_2560 0x1D
#define MCF_I2FDR_IC_3072 0x1E
#define MCF_I2FDR_IC_3840 0x1F


/* Bit definitions and macros for MCF_I2C_I2CR */
#define MCF_I2CR_RSTA      (0x04)
#define MCF_I2CR_TXAK      (0x08)
#define MCF_I2CR_MTX       (0x10)
#define MCF_I2CR_MSTA      (0x20)
#define MCF_I2CR_IIEN      (0x40)
#define MCF_I2CR_IEN       (0x80)

#define MCF_I2CR_RSTA_BIT  2
#define MCF_I2CR_TXAK_BIT  3
#define MCF_I2CR_MTX_BIT   4
#define MCF_I2CR_MSTA_BIT  5
#define MCF_I2CR_IIEN_BIT  6
#define MCF_I2CR_IEN_BIT   7

/* Bit definitions and macros for MCF_I2C_I2SR */
#define MCF_I2SR_RXAK      (0x01)
#define MCF_I2SR_IIF       (0x02)
#define MCF_I2SR_SRW       (0x04)
#define MCF_I2SR_IAL       (0x10)
#define MCF_I2SR_IBB       (0x20)
#define MCF_I2SR_IAAS      (0x40)
#define MCF_I2SR_ICF       (0x80)

#define MCF_I2SR_RXAK_BIT      (0)
#define MCF_I2SR_IIF_BIT       (1)
#define MCF_I2SR_SRW_BIT       (2)
#define MCF_I2SR_IAL_BIT       (4)
#define MCF_I2SR_IBB_BIT       (5)
#define MCF_I2SR_IAAS_BIT      (6)
#define MCF_I2SR_ICF_BIT       (7)

/********************************************************************/

#endif
