/****************************************************************************/

/*
 *	m528xsim.h -- ColdFire 5280/5282 System Integration Module support.
 *
 *	(C) Copyright 2003, Greg Ungerer (gerg@snapgear.com)
 */

/****************************************************************************/
#ifndef	m528xsim_h
#define	m528xsim_h
/****************************************************************************/

#include <linux/config.h>

/*
 *	Define the 5280/5282 SIM register set addresses.
 */
#define	MCFICM_INTC0		0x0c00		/* Base for Interrupt Ctrl 0 */
#define	MCFICM_INTC1		0x0d00		/* Base for Interrupt Ctrl 0 */
#define	MCFINTC_IPRH		0x00		/* Interrupt pending 32-63 */
#define	MCFINTC_IPRL		0x04		/* Interrupt pending 1-31 */
#define	MCFINTC_IMRH		0x08		/* Interrupt mask 32-63 */
#define	MCFINTC_IMRL		0x0c		/* Interrupt mask 1-31 */
#define	MCFINTC_INTFRCH		0x10		/* Interrupt force 32-63 */
#define	MCFINTC_INTFRCL		0x14		/* Interrupt force 1-31 */
#define	MCFINTC_IRLR		0x18		/* */
#define	MCFINTC_IACKL		0x19		/* */
#define	MCFINTC_ICR0		0x40		/* Base ICR register */

#define	MCFINT_VECBASE		64		/* Vector base number */
#define	MCFINT_UART0		13		/* Interrupt number for UART0 */
#define	MCFINT_PIT1		55		/* Interrupt number for PIT1 */
#define	MCFINT_PIT2		56		/* Interrupt number for PIT2 */
#define	MCFINT_PIT3		57		/* Interrupt number for PIT3 */
#define	MCFINT_PIT4		58		/* Interrupt number for PIT4 */

/*
 *	SDRAM configuration registers.
 */
#define	MCFSIM_DCR		0x44		/* SDRAM control */
#define	MCFSIM_DACR0		0x48		/* SDRAM base address 0 */
#define	MCFSIM_DMR0		0x4c		/* SDRAM address mask 0 */
#define	MCFSIM_DACR1		0x50		/* SDRAM base address 1 */
#define	MCFSIM_DMR1		0x54		/* SDRAM address mask 1 */

#define MCFSIM_PQSPAR		0x100058	/* Pin assignment post QS */

//***************  EPORT register offsets ************************************
#define MCF_EPPAR	0x00130000	/*EPORT pin assignment register  */
#define MCF_EPDDR	0x00130002	/*EPORT data direction register  */
#define MCF_EPIER	0x00130003	/*EPORT interrupt enable register  */
#define MCF_EPDR	0x00130004	/*EPORT data register       */
#define MCF_EPPDR	0x00130005	/*EPORT pin data register     */
#define MCF_EPFR	0x00130006	/*EPORT flag register         */
/***************************************************************************/

/***************  GPIO register offsets ************************************/
#define MCF_GPIO_PORTA  0x00100000	/* GPIO PortA output register    */
#define MCF_GPIO_PORTB  0x00100001	/* GPIO PortB output register    */
#define MCF_GPIO_PORTC  0x00100002	/* GPIO PortC output register    */
#define MCF_GPIO_PORTD  0x00100003	/* GPIO PortD output register    */
#define MCF_GPIO_PORTE  0x00100004	/* GPIO PortE output register    */

#define MCF_GPIO_PEPAR  0x00100052	/* PortE pin assignment register */

#define MCF_GPIO_DDRE   0x00100018	/* PortE data direction register */
 /****************************************************************************/

/*
 *	Define the 5282 watchdog register set addresses.
 */
#define MCFSIM_WCR              0x00140000      /* watchdog control register */
#define MCFSIM_WMR              0x00140002      /* watchdog modulus register */
#define MCFSIM_WCNTR            0x00140004      /* watchdog count register */
#define MCFSIM_WSR              0x00140006      /* watchdog service register */


/****************************************************************************/
#endif	/* m528xsim_h */
