#ifndef MCF528x_DMA_TIMER_H_INCLUDED
#define MCF528x_DMA_TIMER_H_INCLUDED
#if defined(CONFIG_M527x)||defined(CONFIG_M528x)||defined(CONFIG_M532x)
//==============================================================
// MCF5282 chapter 21: DMA Timers
// MCF5271 chapter 22: DMA Timers
//==============================================================
typedef volatile unsigned char  BYTE_REG;
typedef volatile unsigned short WORD_REG;
typedef volatile unsigned long  LONG_REG;

/* Bit level definitions and macros */
#define DTMR_PS(a)			((((a)-1)&0x00FF)<<8)
//-----------------------------------------------
// bits use in the registers
//-----------------------------------------------
enum E_DTMR_CE
{
	DTMR_CE_ANY=3<<6,
	DTMR_CE_FALL=2<<6,
	DTMR_CE_RISE=1<<6,
	DTMR_CE_NONE=0<<6,
};
enum E_DTMR_OM
{
	DTMR_OM_1=1<<5,
	DTMR_OM_0=0<<5
};
enum E_DTMR_ORRI
{
	DTMR_ORRI_1=1<<4,
	DTMR_ORRI_0=0<<4
};
enum E_DTMR_FFR
{
	DTMR_FRR_1=1<<3,
	DTMR_FRR_0=0<<3
};
enum E_DTMR_CLK
{
	DTMR_CLK_DTIN=3<<1,
	DTMR_CLK_DIV16=2<<1,
	DTMR_CLK_DIV1=1<<1,
	DTMR_CLK_STOP=0<<1
};
enum E_DTMR_RST
{
	DTMR_RST_1=1<<0,
	DTMR_RST_0=0<<0,
//#define DTMR_RST				(0x0001)
};

enum E_DTXMR_DMAEN
{
	DTXMR_DMAEN_1=1<<7,
	DTXMR_DMAEN_0=0<<7
};
enum E_DTXMR_MODE16
{
	DTXMR_MODE16_1=1<<0,
	DTXMR_MODE16_0=0<<0
};
#define DTER_REF				(0x02)
#define DTER_CAP				(0x01)

struct S_MCF_DMA_TIMER
{
	WORD_REG dtmr;		// 0x400 DMA TimerX Mode Register
	BYTE_REG dtxmr;		// 0x402 DMA Timerx Extended Mode Register
	BYTE_REG dter;		// 0x403 DMA Timerx Event Register
	LONG_REG dtrr;		// 0x404 DMA Timerx Reference Register
	LONG_REG dtcr;		// 0x408 DMA Timerx Capture Register
	LONG_REG dtcn;		// 0x40C DMA Timerx Counter Register
};

#if defined(CONFIG_M527x)||defined(CONFIG_M528x)
#define MCF_DMA_TIMER0 (*(struct S_MCF_DMA_TIMER*)0x40000400)
#define MCF_DMA_TIMER1 (*(struct S_MCF_DMA_TIMER*)0x40000440)
#define MCF_DMA_TIMER2 (*(struct S_MCF_DMA_TIMER*)0x40000480)
#define MCF_DMA_TIMER3 (*(struct S_MCF_DMA_TIMER*)0x400004C0)

#define MCF_DMA_TIMER(n) (*(struct S_MCF_DMA_TIMER*)(0x40000400+(n)*0x40))

#define MCFDTIM0_IRQ_INT	19
#define MCFDTIM0_IRQ_VECTOR    (64+MCFDTIM0_IRQ_INT)
#endif

#if defined(CONFIG_M532x)
#define MCF_DMA_TIMER0 (*(struct S_MCF_DMA_TIMER*)0xFC070000)
#define MCF_DMA_TIMER1 (*(struct S_MCF_DMA_TIMER*)0xFC074000)
#define MCF_DMA_TIMER2 (*(struct S_MCF_DMA_TIMER*)0xFC078000)
#define MCF_DMA_TIMER3 (*(struct S_MCF_DMA_TIMER*)0xFC07C000)

#define MCF_DMA_TIMER(n) (*(struct S_MCF_DMA_TIMER*)(0xFC070000+(n)*0x4000))

#define MCFDTIM0_IRQ_INT	32
#define MCFDTIM0_IRQ_VECTOR    (64+MCFDTIM0_IRQ_INT)
#endif

struct S_MCF_DMA_TIMER* request_hrt_timer(int *intr_request_vector);
void release_hrt_timer(struct S_MCF_DMA_TIMER* timer);
void start_hrt_timer(struct S_MCF_DMA_TIMER* timer,unsigned long delay);
void stop_hrt_timer(struct S_MCF_DMA_TIMER* timer);
void release_hrt_timer(struct S_MCF_DMA_TIMER* timer);
void reinit_hrt_timer(struct S_MCF_DMA_TIMER* timer);

//#define set_hrt_timeout(timer,delay) ((timer->dtrr)=(delay))


#endif	// CPU
#endif	// MCF528x_DMA_TIMER_H_INCLUDED
