/****************************************************************************/

/*
 *	mcfuart.h -- ColdFire internal UART support defines.
 *
 *	(C) Copyright 1999-2003, Greg Ungerer (gerg@snapgear.com)
 * 	(C) Copyright 2000, Lineo Inc. (www.lineo.com) 
 */

/****************************************************************************/
#ifndef	DUART_h
#define	DUART_h
/****************************************************************************/

#include <linux/config.h>

/*
 *	Define the base address of the UARTS within the MBAR address
 *	space.
 */
 
#if  defined(CONFIG_SAG_PR5800_CORE) 
#define DUART1_BASE	0x80000000
#define DUART2_BASE	0x80000100
#define DUART3_BASE	0x80000200
#endif
#if  defined(CONFIG_SAG_PR5410_CORE) 
#define DUART1_BASE	0x80000000
#define DUART2_BASE	0x80010000
#endif

/*
 *	Define the ColdFire UART register set addresses.
 */
#define	DUART_UMR		0x00		/* Mode register (r/w) */
#define	DUART_USR		0x01		/* Status register (r) */
#define DUART_UCSR		0x01		/* clock select register */
#define	DUART_UCR		0x02		/* Command register (w) */
#define	DUART_URB		0x03		/* Receiver Buffer (r) */
#define	DUART_UTB		0x03		/* Transmit Buffer (w) */
#define	DUART_UIPCR		0x04		/* Input Port Change (r) */
#define	DUART_UACR		0x04		/* Auxiliary Control (w) */
#define	DUART_UISR		0x05		/* Interrup Status (r) */
#define	DUART_UIMR		0x05		/* Interrupt Mask (w) */
#define	DUART_UIPR		0x0d		/* Input Port (r) */
#define	DUART_UOP1		0x0e		/* Output Port Bit Set (w) */
#define	DUART_UOP0		0x0f		/* Output Port Bit Reset (w) */




/*
 *	Define bit flags in Mode Register 1 (MR1).
 */
#define	DUART_MR1_RXRTS		0x80		/* Auto RTS flow control */
#define	DUART_MR1_RXIRQFULL	0x40		/* RX IRQ type FULL */
#define	DUART_MR1_RXIRQRDY	0x00		/* RX IRQ type RDY */
#define	DUART_MR1_RXERRBLOCK	0x20		/* RX block error mode */
#define	DUART_MR1_RXERRCHAR	0x00		/* RX char error mode */

#define	DUART_MR1_PARITYNONE	0x10		/* No parity */
#define	DUART_MR1_PARITYEVEN	0x00		/* Even parity */
#define	DUART_MR1_PARITYODD	0x04		/* Odd parity */
#define	DUART_MR1_PARITYSPACE	0x08		/* Space parity */
#define	DUART_MR1_PARITYMARK	0x0c		/* Mark parity */

#define	DUART_MR1_CS5		0x00		/* 5 bits per char */
#define	DUART_MR1_CS6		0x01		/* 6 bits per char */
#define	DUART_MR1_CS7		0x02		/* 7 bits per char */
#define	DUART_MR1_CS8		0x03		/* 8 bits per char */

/*
 *	Define bit flags in Mode Register 2 (MR2).
 */
#define	DUART_MR2_LOOPBACK	0x80		/* Loopback mode */
#define	DUART_MR2_REMOTELOOP	0xc0		/* Remote loopback mode */
#define	DUART_MR2_AUTOECHO	0x40		/* Automatic echo */
#define	DUART_MR2_TXRTS		0x20		/* Assert RTS on TX */
#define	DUART_MR2_TXCTS		0x10		/* Auto CTS flow control */

#define	DUART_MR2_STOP1		0x07		/* 1 stop bit */
#define	DUART_MR2_STOP15	0x08		/* 1.5 stop bits */
#define	DUART_MR2_STOP2		0x0f		/* 2 stop bits */

/*
 *	Define bit flags in Status Register (USR).
 */
#define	DUART_USR_RXBREAK	0x80		/* Received BREAK */
#define	DUART_USR_RXFRAMING	0x40		/* Received framing error */
#define	DUART_USR_RXPARITY	0x20		/* Received parity error */
#define	DUART_USR_RXOVERRUN	0x10		/* Received overrun error */
#define	DUART_USR_TXEMPTY	0x08		/* Transmitter empty */
#define	DUART_USR_TXREADY	0x04		/* Transmitter ready */
#define	DUART_USR_RXFULL	0x02		/* Receiver full */
#define	DUART_USR_RXREADY	0x01		/* Receiver ready */

#define	DUART_USR_RXERR	(DUART_USR_RXBREAK | DUART_USR_RXFRAMING | \
				DUART_USR_RXPARITY | DUART_USR_RXOVERRUN)

/*
 *	Define bit flags in Clock Select Register (UCSR).
 */
#define	DUART_UCSR_RXCLKTIMER	0xd0		/* RX clock is timer */
#define	DUART_UCSR_RXCLKEXT16	0xe0		/* RX clock is external x16 */
#define	DUART_UCSR_RXCLKEXT1	0xf0		/* RX clock is external x1 */

#define	DUART_UCSR_TXCLKTIMER	0x0d		/* TX clock is timer */
#define	DUART_UCSR_TXCLKEXT16	0x0e		/* TX clock is external x16 */
#define	DUART_UCSR_TXCLKEXT1	0x0f		/* TX clock is external x1 */

/*
 *	Define bit flags in Command Register (UCR).
 */
#define	DUART_UCR_CMDNULL		0x00	/* No command */
#define	DUART_UCR_CMDRESETMRPTR		0x10	/* Reset MR pointer */
#define	DUART_UCR_CMDRESETRX		0x20	/* Reset receiver */
#define	DUART_UCR_CMDRESETTX		0x30	/* Reset transmitter */
#define	DUART_UCR_CMDRESETERR		0x40	/* Reset error status */
#define	DUART_UCR_CMDRESETBREAK		0x50	/* Reset BREAK change */
#define	DUART_UCR_CMDBREAKSTART		0x60	/* Start BREAK */
#define	DUART_UCR_CMDBREAKSTOP		0x70	/* Stop BREAK */

#define	DUART_UCR_TXNULL		0x00		/* No TX command */
#define	DUART_UCR_TXENABLE		0x04		/* Enable TX */
#define	DUART_UCR_TXDISABLE		0x08		/* Disable TX */
#define	DUART_UCR_RXNULL		0x00		/* No RX command */
#define	DUART_UCR_RXENABLE		0x01		/* Enable RX */
#define	DUART_UCR_RXDISABLE		0x02		/* Disable RX */

/*
 *	Define bit flags in Input Port Change Register (UIPCR).
 */
#define	DUART_UIPCR_CTSCOS	0x10		/* CTS change of state */
#define	DUART_UIPCR_CTS		0x01		/* CTS value */

/*
 *	Define bit flags in Input Port Register (UIP).
 */
#define	DUART_UIPR_CTSA		0x01		/* CTS channel a value */
#define	DUART_UIPR_CTSB		0x02		/* CTS channel b value */
#define DUART_UIPR_DCDB		0x04		/* DCD channel B value*/
#define DUART_UIPR_RIB		0x08		/* RNG channel B value*/

/*
 *	Define bit flags in Output Port Registers (UOP).
 *	Clear bit by writing to UOP0, set by writing to UOP1.
 */
#define	DUART_UOP_RTSA		0x01		/* RTS set or clear */
#define	DUART_UOP_RTSB		0x02		/* RTS set or clear */

#define DUART_UOP_DTRB		0x04		/* DTR channel B set or clear */

/*
 *	Define bit flags in the Auxiliary Control Register (UACR).
 */
#define	DUART_UACR_IEC		0x01		/* Input enable control */

/*
 *	Define bit flags in Interrupt Status Register (UISR).
 *	These same bits are used for the Interrupt Mask Register (UIMR).
 */
#define	DUART_UIR_COS		0x80		/* Change of state (CTS) */
#define	DUART_UIR_DELTABREAK	0x04		/* Break start or stop */
#define	DUART_UIR_RXREADYA	0x02		/* Receiver ready channel A*/
#define	DUART_UIR_TXREADYA	0x01		/* Transmitter ready channel B*/
#define	DUART_UIR_RXREADYB	0x20		/* Receiver ready channel A*/
#define	DUART_UIR_TXREADYB	0x10		/* Transmitter ready channel B */

#ifdef	CONFIG_M5272
/*
 *	Define bit flags in the Transmitter FIFO Register (UTF).
 */
#define	DUART_UTF_TXB		0x1f		/* Transmitter data level */
#define	DUART_UTF_FULL		0x20		/* Transmitter fifo full */
#define	DUART_UTF_TXS		0xc0		/* Transmitter status */

/*
 *	Define bit flags in the Receiver FIFO Register (URF).
 */
#define	DUART_URF_RXB		0x1f		/* Receiver data level */
#define	DUART_URF_FULL		0x20		/* Receiver fifo full */
#define	DUART_URF_RXS		0xc0		/* Receiver status */
#endif

/****************************************************************************/
#endif	/* DUART_h */
