#ifndef _CRYPTO_RSA_H
#define _CRYPTO_RSA_H

/*
 * struct rsa_op: multi-precision integer operand
 * @data: array that holds the number absolute value
 * @sign: 1 for negative, 0 for positive
 * @size: significant number limbs
 * @limbs: allocated limbs (sizeof data)
 */
typedef struct rsa_op {
	u32 *data;
	int sign;
	int size;
	int limbs;
} rsa_op;

int	rsa_op_alloc(rsa_op **, int);
void	rsa_op_free(rsa_op *);
int 	rsa_op_init(rsa_op **, u8 *, u32, u32);
int 	rsa_op_set(rsa_op **, u8 *, u32);
int	rsa_op_copy(rsa_op **, rsa_op *);
void	rsa_op_print(rsa_op *, int);
int 	rsa_cipher(rsa_op **, rsa_op *, rsa_op *, rsa_op *);

#endif
