/***************************************************************************
                          sag_modbus.h  -  description
                             -------------------
    begin                : Mo Dec 14 2005
    copyright            : (C) 2005 by Sartorius Hamburg GmbH
    email                : andreas.horn@sartorius.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __LINUX_N_asycom_H__
#define __LINUX_N_asycom_H__

/* line disciplines for asycom protocol */

/*
 * Ioctl-commands
 */

#define ASYCOM_SET_SLVADDR        0x5304
#define ASYCOM_IO_TELEGRAMM       0x5305

#define RX_BUF_SIZE 260
#define TX_BUF_SIZE 260

typedef signed char SBYTE;
typedef unsigned char UBYTE;
typedef unsigned short UWORD;
typedef const void *CADDR;

typedef void *ADDR;
typedef unsigned long ULONG;

struct ASYCOM_PARA
{
CADDR obuf;		/* pointer to data to send */
UWORD osiz;		/* number of bytes to send */
ADDR  ibuf;		/* pointer to receive buf */
UWORD isiz;		/* size of input buffer */
ULONG timo;		/* timeout in msec */
UWORD id;		/* our slave address */
UWORD icnt;		/* return: number of received chars */
SBYTE status;		/* status */
SBYTE mode;		/* asycom V1,V2,V3 */
UWORD nbuf;		/* number of receive buffers */

};

/* control char used for this comunication */
#define SOH 0x01
#define STX 0x02
#define ETX 0x03
#define EOT 0x04
#define ENQ 0x05
#define ACK 0x06
#define DLE 0x10
#define NAK 0x15
#define POL 0x70


#define IO_QUEUED 0
#define IO_PROGRESS 1	/* receive or transmitt active */
#define IO_SUCCESS  2   /* transfer of data was successfull */
#define IO_PARA_ERR -1	/* parameter error */
#define IO_TIMEOUT  -4  /* timeout error */
#define IO_POWERFAIL  -3  /* powerfail */
#define IO_PHYSICAL_ERR -5 /* an receive error has occured */


#ifdef __KERNEL__

/*
 * flags definition
*/
#define SUCCESS 1
#define TIMEOUT 2
#define RXCERR  4

/* i/o states */
typedef enum
{
IDLE,
TX_TRANSMITT,
TRANSMITT_BUFFER_EMPTY,
RECEIVE_MESSAGE,
NO_MESSAGE,
UNREQUESTED
#define asycom_num_states (UNREQUESTED+1)
} e_asycom_state;

/*
 * Timeouts (msecs/10 msecs per timer interrupt):
 */

#define WAIT_BEFORE_BREAK 100/(1000/HZ)
#define WAIT_AFTER_BREAK  30/(1000/HZ)

struct RX_BUF {
	unsigned char rx_buf[RX_BUF_SIZE];
	short	rx_len;
	short   in_use;
};

typedef void(*rxfunc)(void *, const unsigned char ,unsigned char);
struct asycom_info {
	spinlock_t     lock;
	struct tty_struct *tty;
	short 	asycom_mode;
	char	slv_adr;
	char 	prg_id;
	unsigned char seq;
	rxfunc  nextchar;
	int	ilen;			/* number of characters received */
	int	alen;			/* length of answer */
	int     bcc_received;
	int	bcc_calculated ;
	int 	toreceive;
	short	nr_rxbuf;
	short	curr_rxbuf;
	short   last_rxbuf;
	short   rx_len;
	short   rx_dle;
	unsigned char rx_answer;
	struct RX_BUF  *rx_buf;
        unsigned char *rx_position;	/* write position for next received character */
	unsigned char rx_bcc;
	unsigned char *tx_buf;
	short   tx_write_idx;
	short   tx_len;
	unsigned char answer;
	short	tx_busy;

	wait_queue_head_t read_wait;
	wait_queue_head_t write_wait;
	struct semaphore sem;

	unsigned int write_state;
	unsigned int read_state;
	unsigned char flags;
	struct S_MCF_DMA_TIMER* timer;
	int	intr_request_vector;
	struct timer_list tmr;
	int nRetry;
};



#endif
#endif
