/***************************************************************************
                          sag_i2c  -  description
                             -------------------
    begin                : Mo Jan 10 2005
    copyright            : (C) 2005 by Sartorius Hamburg GmbH
    email                : andreas.horn@sartorius.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
** $Log: sag_i2c.h,v $
** Revision 1.5  2006/10/26 07:49:52  dec3ban
** rearranged i2c ioctls
**
** Revision 1.4  2006/10/17 11:31:14  dec3ban
** big work and cleanup
**
** Revision 1.3  2006/07/21 07:55:43  dec3hon
** change E_MODE to E_I2C_MODE
**
** Revision 1.2  2006/04/20 10:52:34  dec3ban
** minor fix in sag_i2c
**
** Revision 1.1  2006/04/11 08:21:38  dec3hon
** new file
**
**
*/

#ifndef __LINUX_SAG_I2C_H__
#define __LINUX_SAG_I2C_H__


#if defined(CONFIG_M527x)
#define MCFI2C_IRQ_INT	17
#endif
#if defined(CONFIG_M532x)
#define MCFI2C_IRQ_INT	30
#endif

#define MCFI2C_IRQ_VECTOR    (64+MCFI2C_IRQ_INT)
/*
 * Ioctl-commands
 */

#define RX_BUF_SIZE 64
#define TX_BUF_SIZE 64


typedef struct I2C_PARA
{
	const unsigned char *obuf;	/* pointer to data to send */
	unsigned short osiz;		/* number of bytes to send */
	unsigned char  *ibuf;		/* pointer to receive buf */
	unsigned short isiz;		/* size of input buffer */
	unsigned short icnt;		/* return: number of received chars */
	unsigned char slvid;		/* i2c lsave address */
}I2C_PARA ;

// IOCTLs
// according to "Documentation/ioctl-number
// groupt 'i'	00-3F	linux/i2o.h is for I2C, so we
//
// in linux/i2o-dev numbers are used uptil 12 we start at 24
//
/*
 * I2O Control IOCTLs and structures
 */
#define I2O_MAGIC_NUMBER	'i'

typedef enum
{
	IOCTL_IO=_IOWR(I2O_MAGIC_NUMBER,24,struct I2C_PARA),
	IOCTL_INKEY=_IOWR(I2O_MAGIC_NUMBER,26,struct I2C_PARA),
	IOCTL_GETKEY=_IOWR(I2O_MAGIC_NUMBER,27,struct I2C_PARA),
}E_I2C_MODE;

#ifdef __KERNEL__

typedef struct i2c_dev {

	unsigned	curr_slvid;
	//------------------
	// this is for sending to i2c device
	//------------------
	unsigned  	tx_len;			// length of data to send
	unsigned	tx_index;		// index for next byte
	unsigned char 	tx_buf[TX_BUF_SIZE];	// tx buffer
	//------------------
	// this is for receiving from i2c device
	//------------------
	unsigned	rx_len;
	unsigned        rx_index;
	unsigned char   rx_buf[RX_BUF_SIZE];

	//------------------
	// keyboard fifo
	//------------------
	unsigned char 	keyb_buf[RX_BUF_SIZE];	// fifo for received keyboard characters
	unsigned int  	keyb_wr_pos;		// write position for next received character
	unsigned int  	keyb_rd_pos;		// read position for next received character
	unsigned 	keyb_count;		// effective number of keys in fifo
	unsigned	keyb_lastbits;		// last seen bits
	struct semaphore keyb_sem;		// semaphore for the keyboard buffer

	wait_queue_head_t xwait;
	int		txrx_sts;		// transfer status

}i2c_dev;

#endif
#endif
