/***************************************************************************
                          sag_modbus.h  -  description
                             -------------------
    begin                : Mo Jan 10 2005
    copyright            : (C) 2005 by Sartorius Hamburg GmbH
    email                : andreas.horn@sartorius.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
** $Log: sag_modbus.h,v $
** Revision 1.6  2006/12/04 10:46:14  dec3ban
** minor fixes in modbus-driver: receive function 7, removed obsolete vars in private struct
**
** Revision 1.5  2005/09/21 10:52:06  dec3hon
** add a define
**
** Revision 1.4  2005/08/26 09:21:50  dec3hon
** *** empty log message ***
**
** Revision 1.3  2005/02/24 08:47:29  dec3hon
** saglinux.kdevelop
**
** Revision 1.2  2005/02/21 06:53:42  dec3hon
** add delay vars
**
** Revision 1.1  2005/02/17 06:23:51  dec3hon
** new file
**
**
*/

#ifndef __LINUX_N_MODBUS_H__
#define __LINUX_N_MODBUS_H__

/* line disciplines for modbus protocol */

/*
 * Ioctl-commands
 */

#define MODBUS_IO_TELEGRAMM       0x5302
#define RX_BUF_SIZE 256
#define TX_BUF_SIZE 256

typedef signed char SBYTE;
typedef unsigned char UBYTE;
typedef unsigned short UWORD;
typedef const void *CADDR;

typedef void *ADDR;
typedef unsigned long ULONG;

struct MODBUS_PARA
{
CADDR obuf;		/* pointer to data to send */
UWORD osiz;		/* number of bytes to send */
ADDR  ibuf;		/* pointer to receive buf */
UWORD isiz;		/* size of input buffer */
ULONG timo;		/* timeout in msec */
UWORD id;		/* our slave address */
UWORD icnt;		/* return: number of received chars */
SBYTE status;		/* status */
};

#define IO_QUEUED 0
#define IO_PROGRESS 1	/* receive or transmitt active */
#define IO_SUCCESS  2   /* transfer of data was successfull */
#define IO_PARA_ERR -1	/* parameter error */
#define IO_TIMEOUT  -4  /* timeout error */
#define IO_POWERFAIL  -3  /* powerfail */
#define IO_PHYSICAL_ERR -5 /* an receive error has occured */


#ifdef __KERNEL__

/* i/o states */
typedef enum
{
	UNREQUESTED,	// dont want any char
	// transmit states
	TX_WAIT_SILENCE,
	TX_READY_TO_TRANSMITT,
	TX_TRANSMITT,
	TX_TRANSMITT_DONE,
	// receive states
	RX_WAIT_SILENCE,
	RX_WAIT_ADDRESS,
	RX_WAIT_FUNCTION,
	RX_NEXT_CHAR,
	RX_CRC_LOW,
	RX_CRC_HIGH,
	RX_RECEIVE_DONE,
#define modbus_num_states (RX_RECEIVE_DONE+1)

} e_modbus_state;
/*
 * flags definition
*/
#define SUCCESS 1
#define TIMEOUT 2
#define RXCERR  4

struct modbus_info {
	spinlock_t     lock;
	struct tty_struct *tty;
	unsigned char priority;
	short	slv_adr;
	int     crc_received;
	int	crc_calculated ;
	int 	toreceive;
	unsigned char *rx_buf;
	int	rx_buf_len;
	int     rx_timeout;
	unsigned char *tx_buf;
	int	tx_buf_len;

	unsigned long delay_35;		/* 3.5 char timeout in usec */
	unsigned long delay_15;		/* 1.5 char timweout in usec */
	int	add_length;		/* marker for additonal chars to receive */
        unsigned int rx_position;	/* write position for next received character */

	wait_queue_head_t wait_for_state;
	struct semaphore sem;

	e_modbus_state state;
	unsigned char flags;
	struct S_MCF_DMA_TIMER* timer;
	int	intr_request_vector;
	struct timer_list tmr;
	int nRetry;
};

#endif
#endif
