/***************************************************************************
                          sag_rawio.h  -  description
                             -------------------
    begin                : Mo Jan 10 2005
    copyright            : (C) 2005 by Sartorius Hamburg GmbH
    email                : andreas.horn@sartorius.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
** $Log: sag_rawio.h,v $
** Revision 1.1  2006/01/25 09:38:23  dec3hon
** new ldisc
**
*/

#ifndef __LINUX_N_MODBUS_H__
#define __LINUX_N_MODBUS_H__

/* line disciplines for rawio */

/*
 * Ioctl-commands
 */

#define RAWIO_WRITEREAD      0x5302
#define RAWIO_SETTIMEOUT     0x5303
#define RX_BUF_SIZE 256
#define TX_BUF_SIZE 256

typedef signed char SBYTE;
typedef unsigned char UBYTE;
typedef unsigned short UWORD;
typedef const void *CADDR;

typedef void *ADDR;
typedef unsigned long ULONG;

struct RAWIO_PARA
{
CADDR obuf;		/* pointer to data to send */
UWORD osiz;		/* number of bytes to send */
ADDR  ibuf;		/* pointer to receive buf */
UWORD isiz;		/* size of input buffer */
ULONG timo;		/* timeout in msec */
UWORD icnt;		/* return: number of received chars */
SBYTE status;		/* status */
SBYTE stopchar;		/* when receiving this char. input is stopped char are copied to input buffer*/
SBYTE startchar;	/* input starts when this char is received not included in input buffer*/
};

#define IO_SUCCESS 0
#define IO_PARA_ERR -1
#define IO_PHYSICAL_ERR -2
#define IO_TIMEOUT -3

#ifdef __KERNEL__
/* receive states */
#define IDLE 0
#define WAIT_FORSTART 1
#define RECEIVING 2

/*
 * flags definition
*/
#define SUCCESS 1
#define TIMEOUT 2
#define RXCERR  4

struct rawio_info {
	spinlock_t     lock;
	struct tty_struct *tty;
	unsigned char priority;
	int	ilen;			/* number of characters received */
	unsigned char *rx_buf;
	short	in_len;		/* max char to read */
	unsigned char *tx_buf;
	short	out_len;		/* number of chars to write */

	wait_queue_head_t read_wait;
	struct semaphore sem;

	unsigned long timeout;
	unsigned int state;
	unsigned char flags;
	SBYTE startchar;	/* input starts when this char is received not included in input buffer*/
	SBYTE stopchar;		/* when receiving this char. input is stopped char are copied to input buffer*/
	struct timer_list tmr;
	int nRetry;
};

#endif
#endif
