/***************************************************************************
                          sag_wmprint.h  -  description
                             -------------------
    begin                : Mo Jan 10 2005
    copyright            : (C) 2005 by Sartorius Hamburg GmbH
    email                : andreas.horn@sartorius.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
** $Log: sag_wmprint.h,v $
** Revision 1.1  2005/02/24 08:47:29  dec3hon
** saglinux.kdevelop
**
**
*/

#ifndef __LINUX_N_WMPRINT_H__
#define __LINUX_N_WMPRINT_H__

/* line disciplines for w&m printer protocol for German PTB*/

/*
 * Ioctl-commands
 */

#define WMPRINTER_IO_TELEGRAMM       0x5303
#define TX_BUF_SIZE 256

typedef signed char SBYTE;
typedef unsigned char UBYTE;
typedef unsigned short UWORD;
typedef const void *CADDR;

typedef void *ADDR;
typedef unsigned long ULONG;


#define IO_QUEUED 0
#define IO_PROGRESS 1	/* receive or transmitt active */
#define IO_SUCCESS  2   /* transfer of data was successfull */
#define IO_PARA_ERR -1	/* parameter error */
#define IO_TIMEOUT  -4  /* timeout error */
#define IO_PHYSICAL_ERR -5 /* an receive error has occured */


#ifdef __KERNEL__

/* i/o states */
#define IDLE 0
#define WAIT_FOR_CONNECT 1
#define SEND_STX 2
#define NEXT_CHAR 3
#define SEND_BCC 4
#define WAIT_FOR_ACK 5
#define ACK_NAK 6
/*
 * flags definition
*/
#define SUCCESS 1
#define TIMEOUT 2
#define SNDERR  4


struct wmprint_info {
	spinlock_t     lock;
	struct tty_struct *tty;
	unsigned char priority;
	unsigned char *tx_buf;
	int	wr_pos;			/* next write to this position */
	int	olen;			/* number of characters in output buffer */
	int	spaceleft;		/* number of characters that can be stored */
	int 	delay;
	unsigned char bcc;
	int 	retry;
	int	to_send;

	wait_queue_head_t read_wait;
	struct semaphore sem;

	unsigned int state;
	unsigned char flags;
	int	intr_request_vector;
	struct timer_list tmr;
	int nRetry;
};

#endif
#endif
