/***************************************************************************
                          sag_xbpi  -  description
                             -------------------
    begin                : Mo Jan 10 2005
    copyright            : (C) 2005 by Sartorius Hamburg GmbH
    email                : andreas.horn@sartorius.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
** $Log: sag_xbpi.h,v $
** Revision 1.5  2005/10/20 11:45:27  dec3hon
** add hrt_timeout
**
** Revision 1.4  2005/09/21 10:52:06  dec3hon
** add a define
**
** Revision 1.3  2005/06/22 12:12:34  dec3ban
** rx_buf and tx_buf memory of xbpi_info
**
** Revision 1.2  2005/02/17 06:24:36  dec3hon
** correct comment
**
** Revision 1.1  2005/01/18 12:36:42  dec3hon
** *** empty log message ***
**
** Revision 1.2  2005/01/10 11:49:28  dec3hon
** new driver
**
*/

#ifndef __LINUX_N_XBPI_H__
#define __LINUX_N_XBPI_H__

/* line disciplines for xbpi protocol */
//#include <asm/termios.h>

/*
 * Ioctl-commands
 */

#define XBPI_IO_TELEGRAMM       0x5301
#define RX_BUF_SIZE 256
#define TX_BUF_SIZE 256

#define XBPI_CDE_MSK        0x90    /* 1001 0000 */
#define XBPI_CDE_KENNUNG    0x80    /* 1xx0 xxxx Zielcodierung */
#define XBPI_CM_BIT         0x20    /* xx1x xxxx CM-Dienst */

typedef signed char SBYTE;
typedef unsigned char UBYTE;
typedef unsigned short UWORD;
typedef const void *CADDR;

typedef void *ADDR;
typedef unsigned long ULONG;

struct XBPI_PARA
{
CADDR obuf;		/* pointer to data to send */
UWORD osiz;		/* number of bytes to send */
ADDR  ibuf;		/* pointer to receive buf */
UWORD isiz;		/* size of input buffer */
ULONG timo;		/* timeout in msec */
UWORD brk;		/* send break if <> 0 */
UWORD icnt;		/* return: number of received chars */
SBYTE status;	/* status */
};

#define IO_QUEUED		0
#define IO_PROGRESS		1		/* receive or transmitt active */
#define IO_SUCCESS		2		/* transfer of data was successfull */
#define IO_PARA_ERR		-1		/* parameter error */
#define IO_POWERFAIL	-3		/* powerfail */
#define IO_TIMEOUT		-4		/* timeout error */
#define IO_PHYSICAL_ERR	-5		/* an receive error has occured */


#ifdef __KERNEL__

/* i/o states */
typedef enum
{
	RX_WAIT_SILENCE,
	RX_WAIT_LEN,
	RX_COMMAND_CHAR,
	RX_NEXT_CHAR,
	RX_WAIT_CHK,
} e_xbpi_state_rx;

typedef enum
{
	IDLE,			// no current iocontrol
	// break states
	WAIT_AFTER_BREAK,
	WAIT_AFTER_BREAK_DONE,
	// transmit states
	TX_WAIT_SILENCE,
	TX_READY_TO_TRANSMIT,
	TX_TRANSMIT,
	TX_TRANSMIT_DONE,
} e_xbpi_state_tx;

/*
 * flags definition
*/
#define RX_SUCCESS		1
#define RX_TIMEOUT		2
#define RX_CERR			4
#define RX_POWERFAIL	8

/*
 * Timeouts (msecs/10 msecs per timer interrupt):
 */

#define WAIT_BEFORE_BREAK_TIME 100/(1000/HZ)
#define WAIT_AFTER_BREAK_TIME  30/(1000/HZ)

struct xbpi_rxbuffer {
	unsigned char buf[RX_BUF_SIZE];
	unsigned char flags;
	unsigned char rx_ready;
	unsigned int position;		/* write position for next received character */
};

struct xbpi_info {
	spinlock_t    lock;
	struct tty_struct *tty;
	unsigned char priority;
	struct xbpi_rxbuffer rx_buf_cs;
	struct xbpi_rxbuffer rx_buf_cm;
	struct xbpi_rxbuffer* rx_buf;
	unsigned char tx_buf[TX_BUF_SIZE];
	unsigned int  rx_tel_len;
	wait_queue_head_t wait_for_state;
	struct semaphore CMsem;
	e_xbpi_state_rx state_rx;
	e_xbpi_state_tx state_tx;
	unsigned long delay_35;		/* 3.5 char timeout in usec */
	unsigned long delay_15;		/* 1.5 char timweout in usec */
	unsigned char bcc;
	struct XBPI_PARA para;
	struct S_MCF_DMA_TIMER* chr_timeout_timer;
	int	intr_request_vector;
	struct timer_list overall_timeout_timer;
	struct timer_list CM_overall_timeout_timer;
	int nRetry;
};

#endif	// #ifdef __KERNEL__
#endif	// #ifndef __LINUX_N_XBPI_H__
