#include <stdlib.h>

#include <sys/time.h>
#include <pthread.h> 
#include <signal.h>
#include <sched.h>
#include <unistd.h>
#include "applicfg.h"
#include "timer.h"

//#define DEBUG_WAR_CONSOLE_ON 1
#define DEBUG_ERR_CONSOLE_ON  1
//#define DEBUG_DBG_CONSOLE_ON 1

pthread_mutex_t CanFestival_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t CanTimer_mutex = PTHREAD_MUTEX_INITIALIZER;

TASK_HANDLE TimerLoopThread;

TIMEVAL next_time_set = TIMEVAL_MAX;

struct timeval last_sig;

#if 0
int EnterTimerMutex(void)
{
	return pthread_mutex_lock(&CanTimer_mutex); 
}

void LeaveTimerMutex(void)
{
	pthread_mutex_unlock(&CanTimer_mutex);
}
#endif

int EnterMutex(void)
{
	return pthread_mutex_lock(&CanFestival_mutex);
}

void LeaveMutex(void)
{
	pthread_mutex_unlock(&CanFestival_mutex);
}

// Sets process priority for CAN Receive Loop
void SetProcessPrio(void)
{
	struct sched_param param;
	param.sched_priority=CONFIG_PRIO_IOCAND_REALTIME;
	sched_setscheduler(0,SCHED_RR,&param);
}

void timer_notify(int sig)
{
	int err;
	gettimeofday(&last_sig,NULL);
	if ((err = EnterMutex()) == 0)
	{
		TimeDispatch();
		LeaveMutex();
	}
	else
	{
		MSG_ERR(0, "timer_notify - Mutex deadlock (retry later): ", err);
		// retry 2 ms later.
		setTimer(2000L);
	}
//	printf("getCurrentTime() return=%u\n", p.tv_usec);
}

#if 0
void initTimer(void)
{

	struct sigaction sact;
	struct itimerval itimer;
	
	// Take first absolute time ref.
	gettimeofday(&last_sig,NULL);

	sigemptyset( &sact.sa_mask );
	sact.sa_flags = 0;
	sact.sa_handler = timer_notify;
	
	sigaction( SIGALRM, &sact, NULL );

	getitimer( ITIMER_REAL, &itimer );

}

void StopTimerLoop(void)
{
	struct itimerval itimer;
	int err;
	itimer.it_interval.tv_sec = 0;        /* Zero seconds */
	itimer.it_interval.tv_usec = 0;       /* zero milliseconds */
	itimer.it_value.tv_sec = 0;           /* Zero seconds */
	itimer.it_value.tv_usec = 0;          /* zero milliseconds */

	if ((err = EnterMutex()) == 0)
	{
		setitimer( ITIMER_REAL, &itimer, NULL );
		LeaveMutex();
	}
	else
	{
		MSG_ERR(0, "StopTimerLoop - Mutex deadlock: ", err);
	}
}

#define maxval(a,b) ((a>b)?a:b)
void setTimer(TIMEVAL value)
{
//	printf("setTimer(TIMEVAL value=%d)\n", value);
	// TIMEVAL is us whereas setitimer wants ns...
	long tv_usec = (maxval(value,1)%1000000L);
	time_t tv_sec = value/1000000L;
	struct itimerval timerValues;
	timerValues.it_value.tv_sec = tv_sec;
	timerValues.it_value.tv_usec = tv_usec;
	timerValues.it_interval.tv_sec = 0;
	timerValues.it_interval.tv_usec = 0;

	setitimer (ITIMER_REAL, &timerValues, NULL);
}

TIMEVAL getElapsedTime(void)
{
	struct timeval p;
	gettimeofday(&p,NULL);
//	printf("getCurrentTime() return=%u\n", p.tv_usec);
	return (p.tv_sec - last_sig.tv_sec)* 1000000L + p.tv_usec - last_sig.tv_usec;
}

TIMEVAL getCurrentTime(void)
{
	struct timeval p;
	gettimeofday(&p,NULL);
//	printf("getCurrentTime() return=%u\n", p.tv_usec);
	return ((TIMEVAL) (p.tv_sec)) * 1000000L + (TIMEVAL) p.tv_usec;
}

#else

long ticks_per_second;

void initTimer(void)
{
#ifdef HW_MCF
    //FIXME: should be repaired in uclibc.
    ticks_per_second = 200;
#else
	ticks_per_second = sysconf(_SC_CLK_TCK);
#endif
	//setTimer(MS_TO_TIMEVAL(1000));
	setTimer(TIMEVAL_MAX);
}

void StopTimerLoop(void)
{
	next_time_set = TIMEVAL_MAX;
}

TIMEVAL getNextTimeDelta(void)
{
	
	TIMEVAL delta;
	if (next_time_set == TIMEVAL_MAX)
		delta = TIMEVAL_MAX;
	else
		delta = next_time_set - getCurrentTime();
	
	return delta;
}

void setTimer(TIMEVAL value)
{
	MSG_ERR(0,"SetTimer:", (int) value);
	if (value == TIMEVAL_MAX)
		next_time_set = TIMEVAL_MAX;
	else		
		next_time_set = getCurrentTime() + value;
}

TIMEVAL getCurrentTime(void)
{
	struct tms p;
	return times(&p);
}

#endif

void StartTimerLoop(TimerCallback_t init_callback)
{
	initTimer();
	// Now done in SetAlarm: EnterMutex();
	// At first, TimeDispatch will call init_callback.
	SetAlarm(NULL, 0, init_callback, 0, 0);
	// see above: LeaveMutex();
}

void CreateReceiveTask(CAN_PORT port, TASK_HANDLE* Thread, void *(*ReceiveLoopPtr) (void *) )
{
	pthread_create(Thread, NULL, ReceiveLoopPtr, (void*)port);
}

void WaitReceiveTaskEnd(TASK_HANDLE Thread)
{
	pthread_kill(Thread, SIGTERM);
	pthread_join(Thread, NULL);
}

