/*
This file is part of CanFestival, a library implementing CanOpen Stack.

Copyright (C): Edouard TISSERANT and Francis DUPIN

See COPYING file for copyrights details.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __data_h__
#define __data_h__

#ifdef __cplusplus
extern "C" {
#endif


/* declaration of CO_Data type let us include all necessary headers
 struct struct_CO_Data can then be defined later
 */
typedef struct struct_CO_Data CO_Data;

#include "applicfg.h"
#include "def.h"
#include "can.h"
#include "objdictdef.h"
#include "objacces.h"
#include "sdo.h"
#include "pdo.h"
#include "states.h"
#include "lifegrd.h"
#include "sync.h"
#include "nmtMaster.h"
#include "emcy.h"
#include "raw.h"

/* This structurs contains all necessary information for a CanOpen node */
struct struct_CO_Data {
	/* Object dictionary */
	UNS8 *bDeviceNodeId;
	const indextable *objdict;
	s_PDO_status *PDO_status;
	quick_index *firstIndex;
	quick_index *lastIndex;
	UNS16 *ObjdictSize;
	const UNS8 *iam_a_slave;
	valueRangeTest_t valueRangeTest;

	/* SDO */
	s_transfer transfers[SDO_MAX_SIMULTANEOUS_TRANSFERTS];
	s_transfer *line_ptr;
	SDOTimeOutCallback_t SDOTimeOutCallback;
	/* s_sdo_parameter *sdo_parameters; */

	/* State machine */
	e_nodeState nodeState;
	s_state_communication CurrentCommunicationState;
	initialisation_t initialisation;
	preOperational_t preOperational;
	operational_t operational;
	stopped_t stopped;

	/* NMT-heartbeat */
	UNS8 *ConsumerHeartbeatCount;
	UNS32 *ConsumerHeartbeatEntries;
	TIMER_HANDLE *ConsumerHeartBeatTimers;
	UNS16 *ProducerHeartBeatTime;
	TIMER_HANDLE ProducerHeartBeatTimer;
	heartbeatError_t heartbeatError;
	e_nodeState NMTable[NMT_MAX_NODE_ID];

	/* SYNC */
	TIMER_HANDLE syncTimer;
	UNS32 *COB_ID_Sync;
	UNS32 *Sync_Cycle_Period;
	/*UNS32 *Sync_window_length;;*/
	post_sync_t post_sync;
	post_TPDO_t post_TPDO;

	/* General */
	UNS8 toggle;
	CAN_HANDLE canHandle;
	scanIndexOD_t scanIndexOD;
	storeODSubIndex_t storeODSubIndex;

	/* DCF concise */
	UNS8* dcf_cursor;
	UNS32 dcf_count_targets;

	/* EMCY */
	e_errorState error_state;
	UNS8 error_history_size;
	UNS8* error_number;
	UNS32* error_first_element;
	UNS8* error_register;
	s_errors error_data[EMCY_MAX_ERRORS];
	post_emcy_t post_emcy;

	/* RAW */
	RAWCallbackTable_t RAWCallbackTable[MAXRAWCHANNELS];

};


#define NMTable_Initializer Unknown_state

#define s_transfer_Initializer (s_transfer) {\
		 nodeId  : 0, \
		 whoami  : 0, \
		 state  : SDO_RESET, \
		 toggle  : 0, \
		 abortCode  : 0, \
		 idx  : 0, \
		 subIdx  : 0, \
		 count  : 0, \
		 offset  : 0, \
		 data : {0}, \
		 dataType  : 0, \
		 timer  : -1, \
		 Callback : NULL \
	  }

#define ERROR_DATA_INITIALIZER  (s_errors) \
	{\
	errCode : 0, \
	errRegMask : 0, \
	active : 0 \
	}

#define s_state_communication_Initializer (s_state_communication) \
	{ \
	csBoot_Up:0, \
	csSDO:0, \
	csEmergency:0, \
	csSYNC:0, \
	csHeartbeat:0, \
	csPDO:0 \
	}

/* A macro to initialize the data in client app.*/
/* CO_Data structure */
#define CANOPEN_NODE_DATA_INITIALIZER(NODE_PREFIX) (CO_Data) {\
	.bDeviceNodeId = & NODE_PREFIX ## _bDeviceNodeId, \
	.objdict = 	NODE_PREFIX ## _objdict, \
	.PDO_status = 	NODE_PREFIX ## _PDO_status, \
	.firstIndex = 	& NODE_PREFIX ## _firstIndex, \
	.lastIndex = 	& NODE_PREFIX ## _lastIndex, \
	.ObjdictSize = 	& NODE_PREFIX ## _ObjdictSize, \
	.iam_a_slave = 	& NODE_PREFIX ## _iam_a_slave, \
	.valueRangeTest = 	NODE_PREFIX ## _valueRangeTest, \
	.ConsumerHeartbeatCount = & NODE_PREFIX ## _highestSubIndex_obj1016, \
	.ConsumerHeartbeatEntries = 	NODE_PREFIX ## _obj1016, \
	.ConsumerHeartBeatTimers = 	NODE_PREFIX ## _heartBeatTimers, \
	.ProducerHeartBeatTime = 	& NODE_PREFIX ## _obj1017, \
	/* SYNC */\
	.COB_ID_Sync = 	& NODE_PREFIX ## _obj1005, \
	.Sync_Cycle_Period = 	& NODE_PREFIX ## _obj1006, \
	 /* Sync_window_length = & NODE_PREFIX ## _obj1007, */ \
	\
	/* General */\
	.scanIndexOD = 	NODE_PREFIX ## _scanIndexOD, \
	\
	/* EMCY */\
	.error_history_size =  sizeof(NODE_PREFIX ## _obj1003) / sizeof(NODE_PREFIX ## _obj1003[0]), \
	.error_number = 	      & NODE_PREFIX ## _highestSubIndex_obj1003, \
	.error_first_element = & NODE_PREFIX ## _obj1003[0], \
	.error_register =      & NODE_PREFIX ## _obj1001, \
	.SDOTimeOutCallback = NULL \
}


#ifdef __cplusplus
};
#endif

#endif /* __data_h__ */


