#ifndef __raw_h__
#define __raw_h__
typedef UNS8 (*RAWCallback_t)(CO_Data* d, Message *m, void * Callbackpara);


/** Set a raw callback function
 * Will be executed when a message on the given cobId comes in.
 */
void RegisterRAWCallBack(CO_Data* d,  UNS32 cobId, RAWCallback_t Callback, void * Callbackpara);

/** Remove a raw callback function
 * Message on the given cobId will be handled likie standard.
 */
void UnRegisterRAWCallBack(CO_Data* d,  UNS32 cobId);

/** Send a raw can message
*/
UNS8 sendRAWMessage (CO_Data* d, Message *m);

/** Treat a RAW frame reception
 * bus_id is hardware dependant
 * return 0xFF if error
 *        0x80 if transfert aborted by the server
 *        0x0  ok
 */
UNS8 proceedRAW (CO_Data* d, Message *m);

typedef struct {
	UNS32 			cobId;
	RAWCallback_t 	Callback;
	void * 			Callbackpara;
} RAWCallbackTable_t;

#define MAXRAWCHANNELS 2


#endif
