/*
This file is part of CanFestival, a library implementing CanOpen Stack. 

Copyright (C): Edouard TISSERANT and Francis DUPIN

See COPYING file for copyrights details.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __TIMERSCFG_H__
#define __TIMERSCFG_H__

#include <pthread.h>
#include <sys/times.h>

#if 0
/* Time unit : us */
/* Time resolution : 64bit (~584942 years) */
#define TIMEVAL signed long long
// #define TIMEVAL_MAX ~(TIMEVAL)0 
#define TIMEVAL_MAX (0x7fffffffffffffffLL)
#define MS_TO_TIMEVAL(ms) ((TIMEVAL)(ms)*1000L)
#define US_TO_TIMEVAL(us) ((TIMEVAL)(us))
#define TIMEVAL_TO_MS(tm) ((TIMEVAL)(tm) / 1000L)
#endif

/* Time unit : jiffies */
/* Time resolution : 32bit (~16 years from start of device) */
#define TIMEVAL clock_t
// #define TIMEVAL_MAX ~(TIMEVAL)0 
#define TIMEVAL_MAX (0x7fffffffL)

extern long ticks_per_second;

#define MS_TO_TIMEVAL(ms) ( ((TIMEVAL)(ms)*ticks_per_second) / 1000L)
#define US_TO_TIMEVAL(us) ( MS_TO_TIMEVAL((us) / 1000L) )
#define TIMEVAL_TO_MS(tm) ( ((TIMEVAL)(tm) * 1000L) / ticks_per_second)

#define TASK_HANDLE pthread_t

#endif
