#include "data.h"
#include "raw.h"
#include "canfestival.h"

/*!
 **
 **
 ** @param d CANOpen data structure
 ** @param m Message to be send
 **
 ** @return as of canSend
 **/
UNS8 sendRAWMessage (CO_Data* d, Message *m)
{
	return canSend(d->canHandle,m);
}

/*!
 **
 **
 ** @param d CANOpen data structure
 ** @param cobId CAN id to be filtered
 ** @param Callback function to be executed
 ** @param Callbackpara parameter for callback function
 **/

void RegisterRAWCallBack(CO_Data* d,  UNS32 cobId, RAWCallback_t Callback, void * Callbackpara)
{
	int i;

	for (i=0; i < MAXRAWCHANNELS; i++)
	{
		if (d->RAWCallbackTable[i].cobId == 0 || d->RAWCallbackTable[i].cobId == cobId)
		{
			d->RAWCallbackTable[i].cobId = cobId;
			d->RAWCallbackTable[i].Callback = Callback;
			d->RAWCallbackTable[i].Callbackpara = Callbackpara;

			break;
		}
	}
}

/*!
 **
 **
 ** @param d CANOpen data structure
 ** @param cobId CAN id to be filtered
 **/

void UnRegisterRAWCallBack(CO_Data* d,  UNS32 cobId)
{
	int i;

	for (i=0; i < MAXRAWCHANNELS; i++)
	{
		if (d->RAWCallbackTable[i].cobId == cobId)
		{
			d->RAWCallbackTable[i].cobId = 0;
			d->RAWCallbackTable[i].Callback = NULL;
			d->RAWCallbackTable[i].Callbackpara = NULL;

			break;
		}
	}
}


/*!
**
 **
 ** @param d CANOpen data structure
 ** @param m received message
 ** @return
 **/

UNS8 proceedRAW (CO_Data* d, Message *m)
{
	int i;
	for (i=0; i< MAXRAWCHANNELS; i++)
	{
		if (d->RAWCallbackTable[i].cobId == m->cob_id.w
		    &&
		    d->RAWCallbackTable[i].Callback != NULL)
		    {
		    	return d->RAWCallbackTable[i].Callback(d,m,d->RAWCallbackTable[i].Callbackpara);
		    }
	}

	return 0xff;
}
