<head>
   <title>Implementation of Python in SIMCA</title>
   <link rel="stylesheet" href="markdown.css">
   <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
   <script type="text/javascript" src="../../CreateTableOfContent.js"></script>
   <script type="text/javascript">
      $(document).ready(function () {
         CreateTableOfContent("table_of_content");
      });
   </script>
</head>
<table class="logo">
   <tr class="logo">
      <td style="text-align:right"><img style="height:54px" src="../../images/sartorius-logo.png" alt="Sartorius Data Analytics" /></td>
   </tr>
   <tr style="height:20px"></tr>
</table>

Implementation of Python in SIMCA
=================================

<div id="table_of_content">Table of content</div>

Python scripting in SIMCA
------------------------

With SIMCA 14, Sartorius Stedim Data Analytics introduces the ability to automate/facilitate tasks in SIMCA using Python scripts.
In order to use Python scripts you must have a license that allows it. Click File | Help to see your license information.

![](../../images/license.png)

Much of the functionality relating to Python can be accessed from the Developer tab.

The Python interpreter is embedded in SIMCA and is accessible through the Python Console, script favorites and Add-Ins tab.

![](../../images/simca_frame.png)<br />
*SIMCA with the Add-Ins tab, Favorites and Python console*

The descriptions that follow assume that you have some experience with Python.
If you have little or no experience with Python we recommend that you follow one of the tutorials in the [Python tutorials section](../../index.html#python_tutorials).

### Developer tab

On the Developer tab you can:

- Open the Python console - Opens as a pane at the bottom of the screen, see the Python console topic.
- Clear console - empties the contents of the pane.
- Reset interpreter - restores all environment variables and imports.
- Set paths - specify more/less directories that SIMCA searches for scripts to add to the Add-Ins tab.
- Add script favorite - Add a script to the Favorites pane.
- Create new script - Creates a new .py file with the necessary boiler plate code.
- Create new add-in - Creates a new .py file with the necessary boiler plate code. Add-ins are automatically available as buttons on the Add-ins tab.
- Python help - Opens the respective reference documentation.

![](../../images/developer_tab.png)

#### Open the Developer tab

If your license allows scripting but you cannot see the Developer tab, click **File | Options | Customize** and in the Customize the Ribbon list,
select the **Developer** check box.

![](../../images/customize.png)


### Python console

The console fills much the same function as the Python interactive interpreter and IDLE. Python commands can be executed directly in the console:

![](../../images/python_console.png)<br />
*Output from script favorites and add-ins will also be printed in the console.*

### Creating and accessing scripts
The easiest way to create a script is to click **Create new script** on the **Developer** tab.
This will create a new .py file with the necessary boiler plate code.

After writing your scripts you can make them accessible in SIMCA in the Favorites pane but not on the Add-Ins tab.

To create a script accessible on the Add-Ins tab, click Create new add-in.

### Script favorites
Python scripts can be added to the Favorites pane, either by dropping .py files in the pane or by right clicking and selecting
**Add script favorites** and browsing for them.

When you click a script favorite, the script is executed.

A tutorial on how to write script favorites can be found [here](tutorial/tutorial.html)

### Add-Ins
To create an add-in, click **Create new add-in** on the **Developer** tab. A new .py file is then created with the necessary boiler plate code.

Add-ins are more complex to write than scripts created using **Create new script** but gives you better control of how they look and behave.

Add-Ins are automatically added if the script file is located in one of the directories that Python searches for modules and contains both the on_command and get_button_name functions.

Directories to search in can be added or deleted by clicking Set paths on the Developer tab.

For a detailed description on how to write add-ins see the [tutorial](add-ins/add-ins.html) or the reference [documentation](technical/ribbonabc.html).

## Tutorials
These describe how to use Python in SIMCA and the functionality available.

- An introduction to using [Python in SIMCA](tutorial/tutorial.html). A 'must' read before you start writing scripts.
- A tutorial that describes how to write [add-ins](add-ins/add-ins.html).

## Reference documentation
- Documentation of [Python functionality](technical/index.html) that SIMCA exports to Python.


## Included Python software

SIMCA comes with a complete version of Python 3.4.0 including all standard libraries.

If you want to install Python separately on your computer it is recommended that you install the same version (can be downloaded [here](https://www.python.org/downloads/release/python-340/))
 for the same platform (x86 or x86-x64) as your SIMCA. If SIMCAs title bar says '32-bit' you need the x86 version, otherwise the x86-x64 version.

SIMCA has been run successfully with other versions of Python installed (like 2.7) but this has not been extensively tested.

Using external Python libraries with SIMCA
----------------------------------------------
If you want to use external Python libraries in scripts run in SIMCA it is recommended that you install Python 3.4.0 (see above) and
install the libraries into this installation using pip.

Ex.

To install numpy (a commonly used linear algebra library), install Python, start a command prompt and change directory to
Python's script directory (for example *c:\python\scrips*) and install using pip.

```
cd c:\python\scrips
pip install numpy
```
This will place the numpy package under *c:\python\Lib\site-packages* which needs to be added to SIMCA python lookup paths with the *Set Path* dialog under the Developer tab.

With pip you can install any library available in the [Python Package Index](https://pypi.python.org/pypi) which covers around 70000
different packages.

Any package installed this way will be available in SIMCA also.

If you don't have permission to install software on your computer, you can usually download the source code of a package to your
computer and add the directory where you saved it to Python paths in SIMCA. Exactly how this is done varies from package to package.
In the case of numpy you can download them from [here](http://sourceforge.net/projects/numpy/files/NumPy/1.10.1/) and add the download
directory to the paths that SIMCA searches for packages ('Set paths' on the 'Developer' tab).

![](../../images/numpy_paths.png)

Debugging Python
---------------
It is not necessary to have a debugger when writing scripts but it can be very useful.
If you want to have a debugger software you need to find one that can use remote access.

More details on how to install and use a Python debugger with SIMCA scripts can be found in our knowledge base.
Search for 'Python debugger' at [http://www.umetrics.com/kb](http://www.umetrics.com/kb).

Why Python?
-----------

Python is relatively easy to learn but at the same time has all the features needed to write well structured, readable and maintainable code.
It also comes with 'batteries included' meaning that there are libraries for everything under the sun. The standard library covers things like
XML parsing, http servers and graphical user interfaces. If the standard library doesn't have the functionality you need there are a plethora
of other free libraries available for things like linear algebra, statistics, encryption, graphics, databases, content management systems
and much more.

### Why not R?

R is licensed under the [GPL](https://en.wikipedia.org/wiki/GNU_General_Public_License) which means that it can not be embedded in an
application unless the application as a whole is licensed under the GPL. Since SIMCA can not be open sourced it prohibits the use of R.

Even if that wasn't the case, R is not a very good choise since it is intended primarily as a domain specific language for statistics
and is not very good as a general purpose programing language. It seems like our customers primarily needs scripting for getting data into SIMCA,
analyze it in SIMCA and get results out. If you need to do scientific computing outside of SIMCA, Python has the neccesary libraries like
[SciPy](https://www.scipy.org/index.html).

### Why not javascript, LUA, lisp ...

We feel that Python is easier to learn, better structured and has better library support than other scripting languages.

<table class="copyright">
   <tr style="height:20px"></tr>
   <tr class="copyright"><td>Copyright&copy; Sartorius Stedim Data Analytics AB</td></tr>
   <tr class="copyright"><td>SIMCA, part of the Umetrics&#174; Suite of Data Analytics Solutions</td></tr>
   <tr class="copyright"><td>SIMCA&#174; Multivariate Data Analytics Solution</td></tr>
</table>