   <title>Python tutorial</title>
   <link rel="stylesheet" href="../markdown15.css">
   <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
   <script type="text/javascript" src="../../../CreateTableOfContent.js"></script>
   <script type="text/javascript">
      $(document).ready(function () {
         CreateTableOfContent("table_of_content");
      });
   </script>
</head>
<table class="logo">
   <tr class="logo">
      <td style="text-align:right"><img style="height:54px" src="../../../images/sartorius-logo.png" alt="Sartorius Data Analytics" /></td>
   </tr>
   <tr style="height:20px"></tr>
</table>

Remote debugging with ptvsd and Visual Studio Code
=====================

Setup SIMCA
-----

1. Initialize a virtual environment (venv) in SIMCA:
```
>>> import umpypkg as pkg
# if first time
>>> pkg.create()
```
2. Generate integration files<br>
```
>>> pkg.vscode()
```
There should now be a new directory '.vscode' under %AppData%\Umetrics\SIMCA\16.0\envs\default
containing a settings.json and a launch.json 

3. Install ptvsd:<br>
```
>>> pkg.install('ptvsd')
```
Setup VS Code
-----

1. Install the latest version of Visual Studio Code (the tutorial was created using version 1.32)
2. Install Python Plugin from Microsoft (Click the Extensions icon and search for Python)
3. Open the location of the venv as Folder in VS Code.<br>
To find it you can print the location in SIMCA.<br>
```
>>>pkg.env_dir
```
![](../../../images/open_env.png)<br>
3. In VS Code click the cogwheel at the bottom left and select 'Command Palette...'. Start typing 'python: Run Selection/Line in Python terminal' and execute the command when selectable.<br>
![](../../../images/run_selection_line.png)<br>
4. Open the debug view (Ctrl+Shift+D) and select Python: Attach in the drop down at the top.<br>
![](../../../images/attach.png)<br>
5. Click the cog-wheel next to it to open launch.json.<br> 
You should see the values "port": 5678 and "host": "127.0.0.1" under the 'Python: Attach' section

Start debugging
-----

1. Open the debug target file in VS Code and add a breakpoint by clicking the margin next to the line number. A red dot will appear, as by magic.<br>
For example open "createproject.py" located in SIMCAs installation folder. 


2. In the SIMCA Python Console run
```
>>> import ptvsd
>>>ptvsd.enable_attach()
#SIMCA will wait on the last expression until VS Code has attached 
>>> ptvsd.wait_for_attach(30) 
```
3. In VS Code click the green play-icon next to 'Python: Attach' 

4. Start Debugging<br>
Run in SIMCA the same file as you opened in step 1 in VS Code, either by clicking the favorite 
or importing and calling it in the console. The breakpoint will be highlighted in VS Code.

<table class="copyright">
   <tr style="height:20px"></tr>
   <tr class="copyright"><td>Copyright&copy; Sartorius Stedim Data Analytics AB</td></tr>
   <tr class="copyright"><td>SIMCA, part of the Umetrics&#174; Suite of Data Analytics Solutions</td></tr>
   <tr class="copyright"><td>SIMCA&#174; Multivariate Data Analytics Solution</td></tr>
</table>