<head>
   <title>Implementation of Python in SIMCA</title>
   <link rel="stylesheet" href="markdown15.css">
   <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
   <script type="text/javascript" src="../../CreateTableOfContent.js"></script>
   <script type="text/javascript">
      $(document).ready(function () {
         CreateTableOfContent("table_of_content");
      });
   </script>
</head>
<table class="logo">
   <tr class="logo">
      <td style="text-align:right"><img style="height:54px" src="../../images/sartorius-logo.png" alt="Sartorius Data Analytics" /></td>
   </tr>
   <tr style="height:20px"></tr>
</table>

Implementation of Python in SIMCA
=================================

<div id="table_of_content">Table of content</div>

Python scripting in SIMCA
------------------------

SIMCA has the ability to automate/facilitate tasks using Python scripts. 
In order to use Python scripts you must have a license that allows it. To check you licence goto **File | Help**.

![](../../images/license.png)

Much of the functionality relating to Python can be accessed from the **Developer** tab.

The Python interpreter is embedded in SIMCA and is accessible through the Python console(**Developer | Python console**), script favorites(**View | Favorites**) and Python script buttons under Add-Ins tab.

![](images/simca_frame.png)<br />
*SIMCA with the Add-Ins tab, Favorites and Python console*

The descriptions that follow assume that you have some experience with Python.
If you have little or no experience with Python we recommend that you follow one of the tutorials in the [Python tutorials section](../../index.html#python_tutorials).

### Developer tab

On the Developer tab you can:

- ***Python console*** - Opens as a pane at the bottom of the screen, see the Python console topic.
- ***Clear console*** - empties the contents of the pane.
- ***Reset interpreter*** - restores all environment variables and imports.
- ***Set paths*** - specify more/less directories that SIMCA searches for scripts to add to the Add-Ins tab.
- ***Add existing script*** - Adds regular scripts to the Favorites pane, Add-in scripts are added as buttons.
- ***Create new script*** - Opens a dialog where to choose type of script to create. All choises comes with necessary boiler plate code.
  - ***Common script*** - Create a new script that can be executed inside SIMCA.
  - ***Button add-in*** - Create new button with custom functionality
  - ***File format*** - a new file format script to read new file types.
  - ***Spectral filter*** - Create a new file type that can be used to preprocess datasets.
- ***Verify-installed add-ins*** - Check error messages
- ***Open add-in folder*** - Opens the default python script folder
- ***Freeze Python environment*** - Save the current Python environment description in the project
- ***Python help*** - Opens the respective reference documentation.

![](images/developer_tab.png)

#### Open the Developer tab

If your license allows scripting but you cannot see the Developer tab, goto **File | Options | Customize** and in the Customize the Ribbon list,
select the **Developer** check box.

![](images/customize.png)


### Python console

The console fills much the same function as the Python interactive interpreter and IDLE. Python commands can be executed directly in the console:

![](images/python_console.png)<br />
*Output from script favorites and add-ins will also be printed in the console.*

## Creating and accessing scripts
There are four different types of scripts available; regular script(**Common script**), ribbon(**Button add-in**), preprocessing(**Spectral filter**) and file format(**File format**).<br>
These scripts are available as .py boiler plate with necessary functionality under **Developer | Create new script**.

### Common scripts
The easiest way to create a script is to goto **Developer | Create new script | Common script**.
After writing your scripts you can make them accessible in SIMCA through the Favorites pane.

#### Script favorites
Python scripts can be added to the Favorites pane, either by dropping .py files in the pane or through **Developer | Add existing script** and browsing for them.
When you click a script favorite, the script is executed.

A tutorial on how to write script favorites can be found [here](tutorial/tutorial.html).

## Add-Ins
Add-ins are more complex to write than **Common script** but enables you to extend the functionality of SIMCA in a better way. <br>

Add-Ins are automatically added if the script file is located in one of the directories that Python searches for modules and contains the required functions.<br>
Directories to search in can be added or deleted in **Developer | Set paths**.<br> <br>

The status and or errors of all loaded add-ins can be seen in **Developer | Verify installed add-ins**

### Ribbon add-ins
Ribbon add-ins enables you to create new buttons that executes scripts. To create a ribbon add-in, goto **Developer | Create new script | Button add-in**. This will create a boiler plate script in the default Python folder which automatically makes the button available in Simca.

For a detailed description on how to write ribbon add-ins see the [tutorial](add-ins/add-ins.html) or the reference [documentation](technical/ribbonabc.html).

### Preprocessing add-ins
To create an add-in accessible in the Calibraition wizard and Preprocessing wizard, goto **Developer | Create new script | Spectral filter**. This will create a boiler plate script in the default Python folder which automatically makes the script available in Simca.<br>

If a preprocessing add-in is found it will be available as a new preprocessing(formerly known as spectral filters) in the **Preprocessing wizard**(**Data | Preprocessing**) and **Calibration wizard**(**Home | Calibration wizard**).
To create a new preprocessing add-in go to **Developer | Create new script | Spectral filter** and a new script is created for you with the necessary functions.
The most important function is **transform**, the default function implemented just takes the square of all values. The matrix returned must always have the same number of rows
as the input data_collection but other than that anything is possible. <br>
If self.generates_new_variables is False then the number of columns is constant, if it is True the number of columns can change and get_variable_name is called for each column.<br>
A project created using a preprocessing add-in will have that script embedded in the project file, prediction will therefore work on other computers without the script.
<br>

If the script depends on external packages and you want to use the project on another computer, you can freeze the current environment (**Developer | Freeze Python environment**) to the project and get an option to restore the same environment on the new computer.

For a detailed description on how to write preprocessing add-ins see the reference [documentation](technical/filterabc.html).

### File format add-ins
To create a new file format add-in goto  **Developer | Create new script | File format**. This will create a boiler plate script in the default Python folder which automatically makes the script available in Simca.
The most important functions are **read** and **write**, the default script has an example of a csv reader implemented as a comment, just uncomment (remove """) to test it.<br>

For a detailed description on how to write file format add-ins see the reference [documentation](technical/simcapluginformat.html).

## Tutorials
These describe how to use Python in SIMCA and the functionality available.

- An introduction to using [Python in SIMCA](tutorial/tutorial.html). A 'must' read before you start writing scripts.
- A tutorial that describes how to write [add-ins](add-ins/add-ins.html).

## Reference documentation
- Documentation of [Python functionality](technical/index.html) that SIMCA exports to Python.

## Included Python software
SIMCA comes with a complete version of Python 3.7.9 including all standard libraries and three external scientific libraries: Pandas, SciPy and NumPy.

If you want to install Python separately on your computer it is recommended that you install the same version (can be downloaded [here](https://www.python.org/downloads/release/python-379/))
 for the same platform (x86 or x86-x64) as your SIMCA. If SIMCAs title bar says '32-bit' you need the x86 version, otherwise the x86-x64 version.

SIMCA has been run successfully with other versions of Python installed (like 2.7) but this has not been extensively tested.

Using external Python libraries with SIMCA
----------------------------------------------

External python libraries are best handled with umpypkg.
umpypkg lets you install any library available in the [Python Package Index](https://pypi.python.org/pypi).
For a detailed description on virtual environments and pypi integration see the reference [documentation](technical/umpypkg.html).

To install numpy (a commonly used linear algebra library), run umpypkg in the SIMCA console.
```
>>> import umpypkg as pkg
>>> pkg.install('numpy')
```

Behind a firewall it may be necessary to load the libraries from another location like this.
```
>>> pkg.install('numpy', from_path='[The directory where to look for 'pkg']')
```

If you have scripts on your computer, for example scripts you have written, you can add the
directory where you saved them to Python paths in SIMCA. It is recommended that you use packages written for the same version of python as SIMCA uses.

![](images/numpy_paths.png)

Debugging Python
---------------
It is not necessary to have a debugger when writing scripts but it can be very useful. If you want to have a debugger software you need to find one that can use remote access. See for example [Remote debuging with ptvsd and VS Code](tutorial/debugging.html).

Why Python?
-----------

Python is relatively easy to learn but at the same time has all the features needed to write well structured, readable and maintainable code.
It also comes with 'batteries included' meaning that there are libraries for everything under the sun. The standard library covers things like
XML parsing, http servers and graphical user interfaces. If the standard library doesn't have the functionality you need there are a plethora
of other free libraries available for things like linear algebra, statistics, encryption, graphics, databases, content management systems
and much more.

### Why not R?

R is licensed under the [GPL](https://en.wikipedia.org/wiki/GNU_General_Public_License) which means that it can not be embedded in an
application unless the application as a whole is licensed under the GPL. Since SIMCA can not be open sourced it prohibits the use of R.

Even if that wasn't the case, R is not a very good choise since it is intended primarily as a domain specific language for statistics
and is not very good as a general purpose programing language. It seems like our customers primarily needs scripting for getting data into SIMCA,
analyze it in SIMCA and get results out. If you need to do scientific computing outside of SIMCA, Python has the neccesary libraries like
[SciPy](https://www.scipy.org/index.html).

### Why not javascript, LUA, lisp ...

We feel that Python is easier to learn, better structured and has better library support than other scripting languages.


<table class="copyright">
   <tr style="height:20px"></tr>
   <tr class="copyright"><td>Copyright&copy; Sartorius Stedim Data Analytics AB</td></tr>
   <tr class="copyright"><td>SIMCA, part of the Umetrics&#174; Suite of Data Analytics Solutions</td></tr>
   <tr class="copyright"><td>SIMCA&#174; Multivariate Data Analytics Solution</td></tr>
</table>