<head>
   <title>Implementation of Python in Easy Analytics</title>
   <link rel="stylesheet" href="../markdown.css">
   <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
   <script type="text/javascript" src="../CreateTableOfContent.js"></script>
   <script type="text/javascript">
      $(document).ready(function () {
         CreateTableOfContent("table_of_content");
      });
   </script>
</head>
<table class="logo">
   <tr class="logo">
      <td style="text-align:right"><img style="height:54px" src="../images/sartorius-logo.png" alt="Sartorius Data Analytics" /></td>
   </tr>
   <tr style="height:20px"></tr>
</table>

Implementation of Python in Easy Analytics
==================================

<div id="table_of_content">Table of content</div>

Accessing Python
----------------

Python scripts can be run by clicking the 'Add data' button on the 'Data Management' page
and selecting 'Run Python script'.

![Add Data](../images/AddData.png)

They can also be run from the Python console.

![Python console](../images/SimplrConsole.png)

To open the Python console, click 'File', 'Options' and 'Show Python console' or press Alt+P.

In the console you can enter commands much like you do in an interactive Python session or in Idle.
All output from scripts that you run will also be output to this window.

In the 'Python scripts' window you can add Python scripts by right clicking and selecting 'Add Script'
or by draging and dropping scripts in the window. Scripts can then be executed by double clicking them.

Included Python software
------------------------

Easy Analytics comes with a complete version of Python 3.5.0 including all standard libraries.

If you want to install Python separately on your computer it is recommended that you install
the same version (can be downloaded [here](https://www.python.org/downloads/release/python-350/))
for the same platform (x86 or x86-x64) as your Easy Analytics.
If Easy Analytics title bar says '32-bit' you need the x86 version, otherwise the x86-x64 version.

Python functionality overview
-----------------------------

The functionality that Easy Analytics makes available to Python covers:

- Reading supported file formats.
- Creating filters.
- Export data to SIMCA.
- Creating plots.
- Generating reports.
- Open/save projects.

The Python functionality is organized like this:

+ [umetrics](umetrics.html) package - The root package for all Easy Analytics functionality.
   + [impdata](umetrics.impdata.html) package - Contains functionality for creating/reading and formatting data that can be imported as datasets in a project.
      + [ImportData](umetrics.impdata.html#ImportData) class - Used to hold data that can be imported as a dataset to a project.
      + [open_file_dialog()](umetrics.impdata.html#-open_file_dialog) method - Opens a file open dialog that lets you select file(s) to read. Has support for all file formats that SIMCA can read.
      + [read_file()](umetrics.impdata.html#-read_file) method - Reads file(s) in one of the supported file formats and returns it as an ImportData object.
   + [UmetricsException](umetrics.html#UmetricsException) class - The exception class used by all functionality in the umetrics package.
   + [umetrics.plot](umetrics.plot.html) package
      + [set_template_file](umetrics.plot.html#-set_template_file) method - Sets the template file when creating new plots.
   + [umetrics.easy_analytics](umetrics.easy_analytics.html) package - functionality for manipulating projects.
      + [MainDataset](umetrics.easy_analytics.html#MainDataset) class - Interface to the main dataset
      + [add_data_item(...)](umetrics.easy_analytics.html#-add_data_item) method - Adds a data item to the available data items.
      + [clear_project(...)](umetrics.easy_analytics.html#-clear_project) method - Removes all data from the current project.
      + [create_plot(...)](umetrics.easy_analytics.html#-create_plot) method - Creates a plot.
      + [delete_data_item(...)](umetrics.easy_analytics.html#-delete_data_item) method - Removes a dataitem from the available data items.
      + [generate_report(...)](umetrics.easy_analytics.html#-generate_report) method - Generates a report.
      + [get_data_item(...)](umetrics.easy_analytics.html#-get_data_item) method - Returns the data items data.
      + [get_deviation_analysis(...)](umetrics.easy_analytics.html#-get_deviation_analysis) method - Returns a deviation analysis matrix
      + [get_main_dataset(...)](umetrics.easy_analytics.html#-get_main_dataset) method - Returns the main dataset (aggregate).
      + [get_variable(...)](umetrics.easy_analytics.html#-get_variable) method - Returns variable specific settings.
      + [number_of_data_items(...)](umetrics.easy_analytics.html#-number_of_data_items) method - Returns the number of data items.
      + [open_project(...)](umetrics.easy_analytics.html#-open_project) method - Opens a project.
      + [save_project(...)](umetrics.easy_analytics.html#-save_project) method - Saves the current project.
      + [save_report(...)](umetrics.easy_analytics.html#-save_report) method - Saves the current report as HTML or PDF.
      + [start_simca(...)](umetrics.easy_analytics.html#-start_simca) method - Starts SIMCA if it is installed.


<table class="copyright">
   <tr style="height:20px"></tr>
   <tr class="copyright"><td>Copyright&copy; Sartorius Stedim Data Analytics AB</td></tr>
   <tr class="copyright"><td>SIMCA, part of the Umetrics&#174; Suite of Data Analytics Solutions</td></tr>
   <tr class="copyright"><td>SIMCA&#174; Multivariate Data Analytics Solution</td></tr>
</table>